<?php
namespace ExpandOps\AAAFoundation\Classes\V1;
defined( 'ABSPATH' ) || exit;
class RuntimeOutput
{
    protected static $entries = [];
    public static function add( string $message, string $level = 'INFO' ): void
    {
        self::$entries[] = '[' . expandops_shared_timestamp() . '] [' . strtoupper($level) . '] ' . $message;
    }
    public static function get(): array
    {
        return array_map( 'esc_html', self::$entries );
    }
    public static function clear(): void
    {
        self::$entries = [];
    }
}
