<?php
namespace ExpandOps\AAAFoundation\Classes\V1;
defined( 'ABSPATH' ) || exit;
use ExpandOps\AAAFoundation\Classes\V1\BaseLog;
use ExpandOps\AAAFoundation\Classes\V1\OptionValidator;
class RegisterSetting
{
    protected static $validation_class_map = [];
    public static function add( string $page_id, string $validation_class )
    {
        self::$validation_class_map[ $page_id ] = $validation_class;
        register_setting(
            $page_id,
            $page_id,
            [
                'sanitize_callback' => [ __CLASS__, 'sanitize_options' ]
            ]
        );
    } 
    public static function sanitize_options( $options )
    {
        $page_id = current_filter(); 
        $page_id = str_replace( 'sanitize_option_', '', $page_id );
        $validation_class = self::$validation_class_map[ $page_id ] ?? null;
        if ( !class_exists( $validation_class ) ) {
            return $options; 
        }
        return OptionValidator::check( $options, $page_id, $validation_class );
    } 
} 
