<?php
namespace ExpandOps\AAAFoundation\Classes\V1;
defined( 'ABSPATH' ) || exit;
class OptionValidator
{
    public static function check( $saved_options, $page_id, $validation_class  )
    {
        $existing_options = get_option( $page_id, [] );
        $validated_passed = [];
        $validated_failed = [];
        if( is_array( $saved_options) )
        {
            foreach ( $saved_options as $field_id => $value )
            {
                $validation_instance = new $validation_class( $field_id, $value, $saved_options );
                if( 
                    !is_array($validation_instance->getResponse()) &&
                    str_starts_with( $validation_instance->getResponse(), '[Validation Failed]' ) 
                ){
                    $validated_failed[$field_id] = $validation_instance->getResponse(); 
                }
                else
                {
                    $validated_passed[$field_id] = $validation_instance->getResponse(); 
                }
            }
        }
        if( !empty($validated_failed) )
        {
            foreach( $validated_failed as $field_id => $validation_message )
            {
                add_settings_error( $page_id . '_messages', $page_id . '_message', $validation_message, 'error' );
            }
        }
        return array_merge($existing_options, $validated_passed);
    } 
    private static function addAdminNotice($validation_message)
    {
        $notices = get_transient('expandops_admin_notices');
        $notices = $notices ? $notices : '';
        $notices .= '<div class="notice notice-error"><p>' . $validation_message . '</p></div>';
        set_transient('expandops_admin_notices', $notices, 2); 
    } 
}