<?php
namespace ExpandOps\AAAFoundation\Classes\V1;
defined( 'ABSPATH' ) || exit;
use ExpandOps\AAAFoundation\Classes\V1\BaseLog;
class Field
{ 
    private array $args;
    private string $id;
    private string $class;
    private string $name;
    private mixed $current_value;
    private string $placeholder;
    private mixed $min;
    private mixed $max;
    private mixed $step;
    private mixed $minlength;
    private mixed $maxlength;
    private mixed $rows;
    private string $readonly;
    private bool $mask;
    private mixed $constant;
    private string $desc;
    private array $field_options;
    private array $checked_options;
    private array $disabled_options;
    function __construct( $args )
    {
        $options = get_option( $args['option_name'] );
        $this->args = $args;
        $this->id = $args['label_for'];
        $this->class = !empty($args['class']) ?$args['class'] : '';
        $this->name = $args['option_name'] . '[' . $this->id . ']';
        $this->current_value = isset($options[$this->id]) ? $options[$this->id] : ''; 
        $this->placeholder = isset($args['placeholder']) ? $args['placeholder'] : '';
        $this->min = isset($args['min']) ? (int) $args['min'] : null;
        $this->max = isset($args['max']) ? (int) $args['max'] : null;
        $this->step = isset($args['step']) ? $args['step'] : null;
        $this->minlength = isset($args['minlength']) ? (int) $args['minlength'] : null;
        $this->maxlength = isset($args['maxlength']) ? (int) $args['maxlength'] : null;
        $this->rows = isset($args['rows']) ? (int) $args['rows'] : null;
        $this->readonly =  isset($args['readonly']) ? 'readonly' : '';
        $this->mask = !empty($args['mask']) ? true : false;
        $this->constant = !empty($args['constant']) ? $args['constant'] : null;
        $this->desc = !empty($args['desc']) ? $args['desc'] : '';
        $this->field_options = !empty($args['field_options']) ? $args['field_options'] : [ 'No field options' => 'No field options' ];
        $this->checked_options = !empty($args['checked_options']) ? $args['checked_options'] : [];
        $this->disabled_options = !empty($args['disabled_options']) ? $args['disabled_options'] : [];
    }
    public function render($callback)
    {
        if ( is_string($callback) && class_exists($callback) && method_exists($callback, 'render') )
        {
            return $callback::render( $this->args ); 
        }
        if (method_exists($this, $callback))
        {
            return $this->{$callback}();
        }
        return '<p>Invalid field callback: ' . htmlspecialchars($callback) . '</p>';
    }
    private function text()
    {
        ob_start();
        ?>
        <input id="<?php echo esc_attr($this->id); ?>" 
            class="<?php echo esc_attr($this->class);?>"
            name="<?php echo esc_attr($this->name); ?>" 
            type="text" 
            value="<?php echo esc_attr($this->current_value); ?>"
            <?php echo $this->minlength !== null ? 'minlength="' . esc_attr($this->minlength) . '"' : ''; ?>
            <?php echo $this->maxlength !== null ? 'maxlength="' . esc_attr($this->maxlength) . '"' : ''; ?>>
        <p class="description"><?php echo wp_kses($this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean();
    } 
    private function textInfo()
    {
        ob_start();
        $placeholder_value = $this->placeholder;
        switch( true )
        {
            case $this->constant !== null:
                $placeholder_value = defined($this->constant) ? constant($this->constant) : 'Undefined';
                break;
        }
        if( 
            $placeholder_value !== '' && 
            $placeholder_value !== 'Undefined' &&
            $this->mask !== false
        ){
            $placeholder_value = str_repeat('*', strlen($placeholder_value));
        }
        ?>
        <input class="<?php echo esc_attr($this->class);?>"
            type="text"
            placeholder="<?php echo esc_attr( $placeholder_value ); ?>"
            <?php echo esc_attr($this->readonly); ?>>
            <p class="description"><?php echo wp_kses($this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean();
    } 
    private function email()
    {
        ob_start();
        $class = !$this->class ? 'regular-text' : $this->class;
        ?>
        <input id="<?php echo esc_attr($this->id); ?>" 
            class="<?php echo esc_attr($class); ?>"
            name="<?php echo esc_attr($this->name); ?>" 
            type="email" 
            value="<?php echo esc_attr($this->current_value); ?>"
            <?php echo esc_attr($this->readonly); ?>>
            <p class="description"><?php echo wp_kses($this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean();
    } 
    private function number() 
    {
        ob_start();
        ?>
        <input id="<?php echo esc_attr($this->id); ?>" 
            class="<?php echo esc_attr($this->class);?>"
            name="<?php echo esc_attr($this->name); ?>" 
            type="number" 
            value="<?php echo esc_attr($this->current_value); ?>"
            <?php echo $this->step !== null ? 'step="' . esc_attr($this->step) . '"' : ''; ?>
            <?php echo $this->min !== null ? 'min="' . esc_attr($this->min) . '"' : ''; ?>
            <?php echo $this->max !== null ? 'max="' . esc_attr($this->max) . '"' : ''; ?>
            <?php echo $this->placeholder !== null ? 'placeholder="' . esc_attr($this->placeholder) . '"' : ''; ?>
            <?php echo esc_attr($this->readonly); ?>>
            <p class="description"><?php echo wp_kses($this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean();
    } 
    private function textarea() 
    {
        ob_start();
        ?>
        <textarea id="<?php echo esc_attr($this->id); ?>" 
            class="<?php echo esc_attr($this->class); ?>"
            name="<?php echo esc_attr($this->name); ?>" 
            <?php echo $this->rows !== null ? 'rows="' . esc_attr($this->rows) . '"' : ''; ?>
            <?php echo esc_attr($this->readonly); ?>
            <?php echo $this->minlength !== null ? 'minlength="' . esc_attr($this->minlength) . '"' : ''; ?>
            <?php echo $this->maxlength !== null ? 'maxlength="' . esc_attr($this->maxlength) . '"' : ''; ?>><?php echo esc_textarea($this->current_value); ?></textarea>
            <p class="description"><?php echo wp_kses($this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean();
    } 
    private function select() 
    {
        ob_start();
        $is_list = array_keys( $this->field_options ) === range( 0, count( $this->field_options ) - 1 );
        ?>
        <select id="<?php echo esc_attr($this->id); ?>"
            class="<?php echo esc_attr($this->class); ?>"
            name="<?php echo esc_attr($this->name); ?>"
            <?php echo esc_attr($this->readonly); ?>>
                <?php foreach( $this->field_options as $value => $display_value ): ?>
                    <?php if($is_list): $value = $display_value; endif; ?>
                    <option value="<?php echo esc_attr($value);?>" <?php echo selected( $value, esc_attr($this->current_value), false ); ?>><?php echo esc_html($display_value);?></option>
                <?php endforeach; ?>
        </select>
        <p class="description"><?php echo wp_kses($this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean();
    } 
    private function radio()
    {
        ob_start(); 
        $i = 0;
        foreach ( $this->field_options as $value => $display_value ):
            $i++;
            $id_for = $this->id . "-$i";
            ?>
            <p>
                <input id="<?php echo esc_attr($id_for); ?>" 
                    class="<?php echo esc_attr($this->class); ?>"
                    type="radio" 
                    name="<?php echo esc_attr($this->name); ?>"
                    value="<?php echo esc_attr($value); ?>"
                    <?php echo checked( $value, esc_attr($this->current_value), false ); ?>>
                <label for="<?php echo esc_attr($id_for); ?>"><?php echo esc_html($display_value); ?></label>
            </p>
        <?php endforeach; ?>
        <p class="description"><?php echo wp_kses( $this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean(); 
    }
    private function checkbox()
    {
        ob_start();
        $current_value = $this->current_value;
        $name = $this->name . '[]'; 
        $i = 0;
        ?>
        <input type="hidden" name="<?php echo esc_attr($name); ?>" value="">
        <?php
        foreach ($this->field_options as $value => $display_value)
        {
            $i++;
            $id_for = $this->id . "-$i"; 
            if( is_array($current_value) && in_array( $value, $current_value ) )
            {
                $is_checked = true; 
            }
            else
            {
                $is_checked = in_array( '_all', $this->checked_options ) || in_array( $value, $this->checked_options ) ? true : false;
            }
            $is_disabled = in_array( $value, $this->disabled_options ) ? true : false;
            ?>
            <p>
                <input id="<?php echo esc_attr($id_for); ?>" 
                    class="<?php echo esc_attr($this->class); ?>"
                    type="checkbox" 
                    name="<?php echo esc_attr($name); ?>"
                    value="<?php echo esc_attr($value); ?>"
                    <?php echo checked($is_checked, true); ?>
                    <?php echo disabled($is_disabled, true); ?>>
                <label for="<?php echo esc_attr($id_for); ?>"><?php echo esc_html($display_value); ?></label>
            </p>
            <?php
        }
        ?>
        <p class="description"><?php echo wp_kses($this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean(); 
    } 
    private function checkboxInfo()
    {
        ob_start();
        foreach ($this->field_options as $value => $display_value)
        {
            $is_checked = in_array( '_all', $this->checked_options ) || in_array( $value, $this->checked_options ) ? true : false;
            ob_start();
            ?>
            <p>
                <input class="<?php echo esc_attr($this->class); ?> mimic-checkbox-readonly"
                    type="checkbox" 
                    <?php echo checked($is_checked, true); ?>>
                <label><?php echo esc_html($display_value); ?></label>
            </p>
            <?php
        }
        ?>
        <p class="description"><?php echo wp_kses($this->desc, Sanitiser::allowedFieldTags() ); ?></p>
        <?php
        return ob_get_clean(); 
    } 
} 