<?php
namespace ExpandOps\AAAFoundation\Classes\V1;
defined( 'ABSPATH' ) || exit;
use ExpandOps\AAAFoundation\Classes\V1\BaseLog;
use ExpandOps\AAAFoundation\Classes\V1\Sanitiser;
class Builder
{
    private string $page_title = '';
    private string $page_id = '';
    private string $page_slug = '';
    private array $page_tabs = [];
    private array $page_tabs_nav = [];
    function __construct(  $page_setup, $page_tabs, $page_tabs_nav )
    {
        $this->page_title = $page_setup['title'];
        $this->page_id = $page_setup['id'];
        $this->page_slug = $page_setup['slug'];
        $this->page_tabs = $page_tabs;
        $this->page_tabs_nav = $page_tabs_nav;
        $this->addSettingsSectionsAndFields();
    } 
    private function addSettingsSectionsAndFields()
    {        
        foreach ( $this->page_tabs as $tab )
        {
            foreach ( $tab['sections'] as $section )
            {
                add_settings_section(
                    $section['id'], 
                    $section['title'], 
                    $section['callback'], 
                    $this->page_slug . '&tab=' . $tab['slug'] 
                );
                if( !empty($section['fields']) )
                {
                    foreach( $section['fields'] as $field )
                    {
                        add_settings_field(
                            $field['id'],
                            $field['title'], 
                            function($args) use ($field) {
                                $field_instance = new Field($args);
                                echo wp_kses( $field_instance->render( $field['callback'] ), Sanitiser::allowedFieldTags() );
                            },
                            $this->page_slug . '&tab=' . $tab['slug'],
                            $section['id'],
                            array_merge($field['args'], [ 'label_for' => $field['id'], 'option_name' => $this->page_id ] )
                        );
                    } 
                }
            }
        }
    } 
    public function tabbed( )
    {
        if ( isset( $_GET['settings-updated'] ) )
        {
            add_settings_error( $this->page_id . '_messages', $this->page_id . '_message', 'Settings saved.', 'updated' );
        }
        settings_errors( $this->page_id . '_messages' );
        $current_tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : array_key_first($this->page_tabs_nav);
        ?>
        <div class="wrap expandops">
            <h1><?php echo esc_html($this->page_title); ?></h1>
            <h2 class="nav-tab-wrapper">
                <?php foreach ($this->page_tabs_nav as $tab_slug => $tab_title): ?>
                    <a href="?page=<?php echo esc_html($this->page_slug); ?>&tab=<?php echo esc_html($tab_slug); ?>" 
                       class="nav-tab <?php echo esc_html($current_tab === $tab_slug ? 'nav-tab-active' : ''); ?>">
                       <?php echo esc_html( (string) $tab_title); ?>
                    </a>
                <?php endforeach; ?>
            </h2>
            <form method="post" action="options.php">
                <?php
                settings_fields( $this->page_id );
                do_settings_sections( $this->page_slug .'&tab=' . $current_tab );
                submit_button();
                ?>
            </form>
        </div>
        <?php
    } 
} 