<?php
namespace ExpandOps\AAAFoundation\Classes\V1;
defined( 'ABSPATH' ) || exit;
use ExpandOps\AAAFoundation\Classes\V1\Builder;
use ExpandOps\AAAFoundation\Classes\V1\BaseLog;
class BasePage
{
    protected array $page_setup = [];
    protected array $page_tabs = [];
    protected array $page_tabs_nav = [];
    protected $render_page;
    function __construct( $title, $slug, $id )
    {
        $this->setPageSetup( $title, $slug, $id );
        $this->setTabs();
        $this->setPageTabsNav();
        $builderInstance = new Builder( $this->getPageSetup(), $this->getPageTabs(), $this->getPageTabsNav() );
        $this->setRenderPage( $builderInstance->tabbed() );
    }
    protected function setRenderPage( $render )
    {
        $this->render_page = $render;
    }
    public function getRenderPage()
    {
        return $this->render_page;
    }
    protected function setTabs()
    {
    } 
    public function getPageTabs()
    {
        return $this->page_tabs;
    }
    protected function setPageSetup( $title, $slug, $id )
    {
        $this->page_setup['title'] = $title;
        $this->page_setup['slug'] = $slug;
        $this->page_setup['id'] = $id;
    }
    public function getPageSetup()
    {
        return $this->page_setup;
    }
    protected function setPageTabsNav()
    {
        foreach ( $this->page_tabs as $tab )
        {
            $this->page_tabs_nav[ $tab['slug'] ] = $tab['title'];
        }
    }
    protected function getPageTabsNav()
    {
        return $this->page_tabs_nav;
    }
} 