<?php
namespace ExpandOps\AAAFoundation\Classes\V1;
defined( 'ABSPATH' ) || exit;
use ExpandOps\AAAFoundation\Classes\V1\BaseLog;
class BaseMenu
{
    protected string $page_title;
    protected string $page_slug;
    protected string $page_capability_requirement;
    protected string $page_id;
    protected string $page_class;
    protected string $parent_slug;
    protected string $validation_class;
    public function __construct( array $args )
    {
        $this->page_title = $args['title'];
        $this->page_slug = $args['slug'];
        $this->page_capability_requirement = !empty($args['page_capability_requirement']) ? $args['page_capability_requirement'] : 'manage_options';
        $this->page_id = $args['id'];
        $this->page_class = $args['page_class'];
        $this->parent_slug = $args['parent_slug'];
        $this->validation_class = $args['validation_class'];
        $this->addSubmenuPage();
        $this->registerSetting();
    }
    protected function addSubmenuPage()
    {
        add_submenu_page(
            $this->parent_slug,
            $this->page_title,
            $this->page_title,
            $this->page_capability_requirement,
            $this->page_slug,
            !isset($_GET['page']) || $_GET['page'] !== $this->page_slug ? '__return_true' : [ $this, 'renderPage' ] 
        );
    }
    protected function registerSetting()
    {
        add_action( 'admin_init', function () { 
            \ExpandOps\AAAFoundation\Classes\V1\RegisterSetting::add( $this->page_id, $this->validation_class ); 
        });
    }
    public function renderPage()
    {
        $page_instance = new $this->page_class(
            $this->page_title,
            $this->page_slug,
            $this->page_id,
            $this->validation_class
        );
        return $page_instance->getRenderPage();
    }
} 