<?php
namespace ExpandOps\AAAFoundation\Classes\V1;
defined( 'ABSPATH' ) || exit;
class BaseLog
{
    protected static $log_prefix = ''; 
    private static function writeLog( $level, $message, $log_prefix = '' )
    {
        if ( defined( 'WP_DEBUG' ) && WP_DEBUG )
        {
            if ( is_bool( $message ) ) {
                $message = $message ? 'true' : 'false';
            } elseif ( ! is_string( $message ) ) {
                $message = wp_json_encode( $message, JSON_UNESCAPED_UNICODE );
            }
            error_log( '[' . $level . '] [' . $log_prefix . '] ' . $message . "\n" );
        }
    }
    public static function info( $message, $log_prefix = '' )
    {
        self::writeLog( 'INFO', $message, $log_prefix );
    }
    public static function warning( $message, $log_prefix = '' )
    {
        self::writeLog( 'WARNING', $message, $log_prefix );
    }
    public static function error( $message, $log_prefix = '' )
    {
        self::writeLog( 'ERROR', $message, $log_prefix );
    }
} 