jQuery(document).ready(function($) {
    $('#expandops_nanomailer_start_test').on('click', function(e) {
        e.preventDefault();

        const $btn = $(this);
        const selectedEmail = $('#verified_email_tester').val();
        const $testOutput = $('#expandops_nanomailer_test_output_target');

        if (!selectedEmail) {
            alert('Please select a verified email.');
            return $btn.prop('disabled', false).text('Start Test');
        }
        
        $testOutput.html('Testing.');
        $btn.prop('disabled', true).text('Testing...');

        // Start dot animation
        let dotCount = 0;
        const dotInterval = setInterval(function() {
            dotCount = (dotCount + 1) % 4; // cycle through 0–3
            const dots = '.'.repeat(dotCount);
            $testOutput.append('<span class="dot">.</span>');
        }, 300);

        $.post(ajaxurl, {
            action: 'expandops_nanomailer_ajax_test',
            _wpnonce: nanomailerData.nonce,
            from: selectedEmail,
            to: nanomailerData.adminEmail,
        })
        .done(function(response) {
            clearInterval(dotInterval); // stop dots
            const output = response.testOutput ?? response.message ?? [ 'No output received.' ];
            const testOutputHtml = Array.isArray(output)
                ? output.map(entry => `<p>${entry}</p>`).join('')
                : `<p>${output}</p>`;
            
            $testOutput.html(testOutputHtml);
        })
        .fail(function(jqXHR, textStatus, errorThrown) {
            clearInterval(dotInterval); // stop dots
            $testOutput.html(`<p class="error">AJAX request failed: ${textStatus} - ${errorThrown}</p>`);
        })
        .always(function() {
            $btn.prop('disabled', false).text('Start Test');
        });
    });
});