<?php
namespace ExpandOps\Nanomailer\Utilities;
defined( 'ABSPATH' ) || exit;
class TestOutput
{
    protected static $entries = [];
    protected static function add( string $level, string $message ): void
    {
        self::$entries[] = '[' . expandops_shared_timestamp() . '] [' . $level . '] ' . $message;
    }
    public static function get(): array
    {
        return array_map( 'esc_html', self::$entries );
    }
    public static function clear(): void
    {
        self::$entries = [];
    }
    public static function info( string $message ): void
    {
        self::add('INFO', $message);
    }
    public static function warning( string $message ): void
    {
        self::add('WARNING', $message);
    }
    public static function error( string $message ): void
    {
        self::add('ERROR', $message);
    }
    public static function success( string $message ): void
    {
        self::add('SUCCESS', $message);
    }
}
