<?php
namespace ExpandOps\Nanomailer\Utilities;
defined( 'ABSPATH' ) || exit;
use ExpandOps\Nanomailer\Utilities\Log;
class RecordActivity
{
    private static function write( $level, $message )
    {
        $existing_data = get_option( 'expandops_nanomailer' );
        if ( !isset($existing_data['activity_record']) || !is_array($existing_data['activity_record']) ) {
            $existing_data['activity_record'] = [];
        }
        $new_record = '[' . expandops_shared_timestamp() . '] [' . $level . '] ' . $message;
        array_unshift( $existing_data['activity_record'], $new_record );
        $existing_data['activity_record'] = array_slice( $existing_data['activity_record'], 0, 20 );
        update_option( 'expandops_nanomailer', $existing_data );
    }
    public static function success( $message )
    {
        self::write( 'SUCCESS', $message );
    }
    public static function warning( $message )
    {
        self::write( 'WARNING', $message );
    }
    public static function error( $message )
    {
        self::write( 'ERROR', $message );
    }
    public static function info( $message )
    {
        self::write( 'INFO', $message );
    }
} 