<?php
namespace ExpandOps\Nanomailer\MenusAndPages;
defined( 'ABSPATH' ) || exit;
use ExpandOps\AAAFoundation\Classes\V1\BasePage;
use ExpandOps\Nanomailer\Utilities\Log;
use ExpandOps\Nanomailer\Config;
class NanomailerAwsSesPage extends BasePage
{
    public function __construct( $title, $slug, $id )
    {
        parent::__construct( $title, $slug, $id );
        $this->setTabs();
    }
    protected function setTabs()
    {
        $this->setSettingsTab();
        $this->setActivityTab();
        $this->setTestingTroubleshootingTab();
    } 
    protected function setSettingsTab()
    {
        $this->page_tabs[] = [
            'id' => 'settings',
            'title' => 'Settings',
            'slug' => 'settings',
            'sections' => [
                [
                    'id' => 'behaviour',
                    'title' => 'Behaviour',
                    'callback' => '__return_false',
                    'fields' => [
                        [
                            'id' => 'route_wp_mail_to_ses',
                            'title' => 'Route All wp_mail() Emails to AWS SES',
                            'callback' => 'radio',
                            'args' => [ 
                                'field_options' => [
                                    'disabled' => 'Disabled',
                                    'enabled' => 'Enabled'
                                ],
                                'desc' => 'When enabled ALL emails sent via wp_mail() will be routed to AWS SES. Setting this field to disabled will turn OFF Nanomailer.',
                            ]
                        ],
                    ], 
                ],
                [
                    'id' => 'aws_ses_details',
                    'title' => 'AWS SES Details',
                    'callback' => '__return_false',
                    'fields' => [
                        [
                            'id' => 'UNUSED_access_key',
                            'title' => 'Access Key',
                            'callback' => 'textInfo',
                            'args' => [ 
                                'class' => 'regular-text',
                                'mask' => false,
                                'readonly' => true,
                                'constant' => 'NANOMAILER_AWS_ACCESS_KEY',
                                'desc' => 'The Access Key for an AWS IAM user with permission to access the SES SendEmail action. This needs to be defined as the php constant \'NANOMAILER_AWS_ACCESS_KEY\' in either wp-config.php or another configuration file.', 
                            ]
                        ],
                        [
                            'id' => 'UNUSED_secret_key',
                            'title' => 'Secret Key',
                            'callback' => 'textInfo',
                            'args' => [ 
                                'class' => 'regular-text',
                                'mask' => true, 
                                'readonly' => true, 
                                'constant' => 'NANOMAILER_AWS_SECRET_KEY', 
                                'desc' => 'The Secret Key for an AWS IAM user with permission to access the SES SendEmail action. This needs to be defined as the php constant \'NANOMAILER_AWS_SECRET_KEY\' in either wp-config.php or another configuration file.<br>This value will be masked for security.', 
                                ]
                        ], 
                        [
                            'id' => 'region',
                            'title' => 'Region',
                            'callback' => 'select',
                            'args' => [ 
                                'field_options' => [
                                    'af-south-1',
                                    'ap-east-1',
                                    'ap-south-2',
                                    'ap-southeast-3',
                                    'ap-southeast-5',
                                    'ap-southeast-4',
                                    'ap-south-1',
                                    'ap-northeast-3	',
                                    'ap-northeast-2',
                                    'ap-southeast-1',
                                    'ap-southeast-2	',
                                    'ap-southeast-7',
                                    'ap-northeast-1',
                                    'ca-central-1',
                                    'ca-west-1',
                                    'eu-central-1',
                                    'eu-west-1',
                                    'eu-west-2',
                                    'eu-south-1',
                                    'eu-west-3',
                                    'eu-south-2',
                                    'eu-north-1',
                                    'eu-central-2',
                                    'il-central-1',
                                    'mx-central-1',
                                    'me-south-1',
                                    'me-central-1',
                                    'sa-east-1',
                                    'us-east-1',
                                    'us-east-2',
                                    'us-west-1',
                                    'us-west-2',
                                ],
                                'desc' => 'Select the region where the AWS SES identities have been created.',
                            ]
                        ],
                        [
                            'id' => 'verified_email_identities',
                            'title' => 'Verified Email Identities',
                            'callback' => 'text',
                            'args' => [ 
                                'class' => 'large-text',
                                'mask' => false, 
                                'readonly' => false,
                                'maxlength' => 200,
                                'desc' => 'Enter a single email identity, or a comma-separated list (maximum of 3), that are <strong>verified</strong> for sending via AWS SES.<br>If wp_mail() passes an unverified email in its "from" header, Nanomailer will fallback to send the email with the first (or only) email entered here and a warning will be recorded in the activity log.',
                            ]
                        ],
                    ], 
                ], 
                [
                    'id' => 'additional_email_headers',
                    'title' => 'Additional Email Headers (Optional)',
                    'callback' => '__return_false',
                    'fields' => [
                        [
                            'id' => 'send_from_name',
                            'title' => 'Send From Name',
                            'callback' => 'text',
                            'args' => [
                                'class' => 'regular-text',
                                'minlength' => 2,
                                'maxlength' => 35,
                                'desc' => 'The name that emails appear to be sent from.<br><strong>Important: If a name is input in this field then it will be used for ALL emails.</strong>',
                            ]
                        ],
                        [
                            'id' => 'reply_to',
                            'title' => 'Reply-To',
                            'callback' => 'email',
                            'args' => [ 
                                'desc' => 'The email where replies are sent to if a recipient clicks reply. <br><strong>Important: If an email is input in this field then it will be used for ALL emails.</strong>',
                            ]
                        ],
                    ], 
                ],
            ], 
        ]; 
    } 
    protected function setActivityTab()
    {
        $this->page_tabs[] = [
            'id' => 'diagnostics',
            'title' => 'Diagnostics',
            'slug' => 'diagnostics',
            'sections' => [
                [
                    'id' => 'activity',
                    'title' => 'Activity',
                    'callback' => '__return_false',
                    'fields' => [
                        [
                            'id' => 'activity_record',
                            'title' => 'Activity Record',
                            'callback' => \ExpandOps\Nanomailer\Fields\ActivityRecordField::class,
                            'args' => []
                        ],
                    ], 
                ], 
            ], 
        ]; 
    } 
    protected function setTestingTroubleshootingTab()
    {
        $this->page_tabs[] = [
            'id' => 'testing_troubleshooting',
            'title' => 'Testing & Troubleshooting',
            'slug' => 'testing-troubleshooting',
            'sections' => [
                [
                    'id' => 'testing',
                    'title' => 'Testing',
                    'callback' => '__return_false',
                    'fields' => [
                        [
                            'id' => 'verified_email_tester',
                            'title' => 'Verified Email Tester',
                            'callback' => \ExpandOps\Nanomailer\Fields\VerifiedEmailTesterField::class,
                            'args' => []
                        ],
                    ], 
                ], 
            ], 
        ]; 
    } 
} 