<?php 
namespace ExpandOps\Nanomailer\Handlers;
defined( 'ABSPATH' ) || exit;
use ExpandOps\Nanomailer\Utilities\Log;
use ExpandOps\Nanomailer\Config;
use ExpandOps\Nanomailer\Services\WpMailToSes;
use ExpandOps\Nanomailer\Utilities\RecordActivity;
use ExpandOps\Nanomailer\Utilities\TestOutput;
class RouteWpMailToSes
{
    public static function handle( $null, $args )
    {
        $ajax_test = expandops_shared_verify_ajax_action('expandops_nanomailer_ajax_test');
        if ( $ajax_test ){ TestOutput::info('wp_mail() is handling the email. Performing setting checks.'); }
        $option = get_option('expandops_nanomailer'); 
        if ( !isset($option['route_wp_mail_to_ses']) || $option['route_wp_mail_to_ses'] !== 'enabled' )
        {
            if ( $ajax_test ){ TestOutput::info('Route All wp_mail() Emails to SES is disabled.'); }
            return $args; 
        }
        $error = false; 
        switch( true )
        {
            case !defined('NANOMAILER_AWS_ACCESS_KEY') || empty(NANOMAILER_AWS_ACCESS_KEY):
                $error = 'NANOMAILER_AWS_ACCESS_KEY is not defined or empty.';
                break;
            case !defined('NANOMAILER_AWS_SECRET_KEY') || empty(NANOMAILER_AWS_SECRET_KEY):
                $error = 'NANOMAILER_AWS_SECRET_KEY is not defined or empty.';
                break;
            case empty($option['region']):
                $error = 'Region is empty.';
                break;
            case empty($option['verified_email_identities']):
                $error = 'Verified Email Identities is empty.';
                break;
        }
        if( $error )
        {
            Log::error( $error );
            RecordActivity::error( $error);
            if ( $ajax_test ){ TestOutput::error( $error ); }
            return false;
        }
        if ( $ajax_test ){ TestOutput::info( 'Setting checks PASSED.' ); }
        $validated_to_array = is_array($args['to']) ? self::validateEmailArray($args['to']) : [ is_email($args['to']) ];
        if ( empty($validated_to_array) )
        {
            $error = 'wp_mail() did not contain any valid "to" email addresses.';
            Log::error( $error );
            RecordActivity::error( $error );
            if ( $ajax_test ){ TestOutput::error( $error ); }
            return false;
        }
        if ( $ajax_test ){ TestOutput::info( 'Start processing args and headers.' ); }
        $validated_subject = is_scalar( $args['subject'] ) ? (string) $args['subject'] : '';
        $validated_message = is_scalar( $args['message'] ) ? (string) $args['message'] : '';
        $headers = $args['headers'] ?? [];
        $validated_cc = [];
        $validated_bcc = [];
        $validated_from_name = '';
        $validated_from_email = '';
        $validated_reply_to = '';
        if ( is_string($headers) )
        {
            $headers = explode( "\n", str_replace("\r\n", "\n", $headers) );
        }
        if ( is_array($headers) )
        {
            foreach ($headers as $header)
            {
                $header = trim($header);
                switch( true )
                {
                    case stripos($header, 'Cc:') === 0:
                        $validated_cc = self::validateEmailArray( explode(',', substr($header, 3)) );
                        break;
                    case stripos($header, 'Bcc:') === 0:
                        $validated_bcc = self::validateEmailArray( explode(',', substr($header, 4)) );
                        break;
                    case stripos($header, 'From:') === 0:
                        $from = trim( substr($header, 5) );
                        if ( preg_match('/^(.*?)\s*<([^>]+)>$/', $from, $matches) )
                        {
                            if (!empty($matches[1]))
                            {
                                $validated_from_name = (string) trim($matches[1]); 
                            }
                            if (!empty($matches[2]))
                            {
                                $validated_from_email = is_email( trim($matches[2]) ); 
                            }
                        }
                        else
                        {
                            $validated_from_email = is_email( $from ); 
                        }
                        break;
                    case stripos($header, 'Reply-To:') === 0:
                        $validated_reply_to = trim( substr($header, 9) ); 
                        $validated_reply_to = is_email( $validated_reply_to );
                        break;
                } 
            } 
        }
        if ( $ajax_test ){ TestOutput::info( 'Finished processing args and headers.' ); }
        $verified_email_identities = explode(',', $option['verified_email_identities']);
        if (
            !in_array($validated_from_email, $verified_email_identities, true) || 
            empty($validated_from_email)
        ){
            $warning = 'Fallback. The "from" email passed by wp_mail() is not listed in Verified Email Identities. Falling back to ' . sanitize_email($verified_email_identities[0]);
            Log::warning( $warning );
            RecordActivity::warning( $warning );
            if ( $ajax_test ){ TestOutput::warning( $warning ); }
            $validated_from_email = $verified_email_identities[0]; 
        }
        $validated_from_name = !empty($option['send_from_name']) ? $option['send_from_name'] : $validated_from_name;
        if ( $ajax_test ){ TestOutput::INFO( 'Email being sent from: ' . sanitize_text_field($validated_from_name) . ' <' . sanitize_email($validated_from_email) . '>' ); }
        if( empty($validated_reply_to) || !empty($option['reply_to']) )
        {
            $validated_reply_to = !empty($option['reply_to']) ? $option['reply_to'] : $validated_from_email;
        }
        if ( $ajax_test ){ TestOutput::INFO( 'Reply-to is set as: ' . sanitize_email($validated_reply_to) ); }
        if ( !empty($args['attachments']) )
        {
            $warning = 'Attachments are not currently supported in this version of Nanomailer.';
            Log::warning( $warning );
            RecordActivity::warning( $warning );
        }
        if ( $ajax_test ){ TestOutput::INFO( 'SES START' ); }
        $result = WpMailToSes::process(
            $validated_to_array,
            $validated_subject,
            $validated_message,
            $validated_from_email,
            $validated_from_name,
            NANOMAILER_AWS_ACCESS_KEY,
            NANOMAILER_AWS_SECRET_KEY,
            $option['region'],
            $validated_reply_to,
            $validated_cc, 
            $validated_bcc, 
        );
        if ( $ajax_test ){ TestOutput::INFO( 'SES END' ); }
        if ( $result['success'] === false )
        {
            return false;  
        }
        return true; 
    } 
    private static function validateEmailArray( $email_array )
    {
        if ( !is_array($email_array) ) {
            return [];
        }
        $email_array = array_map( 'trim', $email_array ); 
        return array_filter( $email_array, 'is_email' ); 
    }
} 