<?php
namespace ExpandOps\Nanomailer\Handlers;
defined( 'ABSPATH' ) || exit;
use ExpandOps\Nanomailer\Utilities\Log;
use ExpandOps\Nanomailer\Config;
class EnqueueScripts
{
    public static function handle()
    {
        if ( isset($_GET['tab']) && $_GET['tab'] === 'testing-troubleshooting' )
        {
            wp_enqueue_script(
                'expandops-nanomailer-ajax-send-test',
                Config::get('plugin_url') . '/app/resources/js/ajax-send-test.js',
                [ 'jquery' ],
                Config::get('version'),
                true
            );
            wp_localize_script( 'expandops-nanomailer-ajax-send-test', 'nanomailerData', [
                'ajaxurl'   => admin_url( 'admin-ajax.php' ),
                'nonce'     => wp_create_nonce('expandops_nanomailer_ajax_test'),
                'adminEmail'=> sanitize_email( get_option('admin_email') )
            ]);
        }
    } 
}