<?php
namespace ExpandOps\Nanomailer\Handlers;
defined( 'ABSPATH' ) || exit;
use ExpandOps\Nanomailer\Utilities\Log;
use ExpandOps\Nanomailer\Utilities\TestOutput;
class AjaxSendTest
{
    public static function handle()
    {
        TestOutput::clear(); 
        TestOutput::info( 'START Test' );
        if ( 
            !isset( $_REQUEST['_wpnonce'] ) || 
            !wp_verify_nonce( sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])), 'expandops_nanomailer_ajax_test' ) 
        ){
            TestOutput::error( 'Action verification failed.' ); 
            wp_send_json([
                'success' => false,
                'message' => TestOutput::get()
            ]);
        }
        if( !current_user_can('manage_options') )
        {
            TestOutput::error( 'The current user can not perform this action.' ); 
            wp_send_json([
                'success' => false,
                'message' => TestOutput::get()
            ]);
        }
        $option = get_option( 'expandops_nanomailer' );
        $error = false; 
        $from = isset( $_POST['from'] ) ? sanitize_email( wp_unslash( $_POST['from'] ) ) : '';
        $to = isset( $_POST['to'] ) ? sanitize_email( wp_unslash( $_POST['to'] ) ) : '';
        switch( true )
        {
            case !$option;
                $error = 'Unexpected error: Unable to get plugin settings.';
                break;
            case empty( $from ) || !is_email( $from ):
                $error = 'Unexpected error: The POST "from" parameter is not set, or is not a valid email.';
                break;
            case empty( $to ) || !is_email( $to ):
                $error = 'Unexpected error: The POST "to" parameter is not set, or is not a valid email.';
                break; 
        }
        if ( $error )
        {
            TestOutput::error( $error ); 
            wp_send_json([
                'success' => false,
                'message' => TestOutput::get()
            ]);
        }
        $subject = 'Verified Email Test';
        $body = 'This test email was sent by the Nanomailer for AWS SES WordPress plugin at ' . expandops_shared_timestamp();
        $headers = [
            'From: Nanomailer <' . $from . '>',
        ];
        TestOutput::info( 'Email content created. Passing to wp_mail()' );
        $status = wp_mail( $to, $subject, $body, $headers );
        TestOutput::info( 'END Test.' );
        wp_send_json([
            'success' => $status, 
            'testOutput' => TestOutput::get()
        ]);
    } 
}