<?php
namespace ExpandOps\Nanomailer\Fields;
defined( 'ABSPATH' ) || exit;
use ExpandOps\Nanomailer\Utilities\Log;
use ExpandOps\Nanomailer\Config;
class VerifiedEmailTesterField
{
    public static function render()
    {
        $option = get_option('expandops_nanomailer');
        $admin_email = get_option( 'admin_email' );
        switch( true )
        {
            case !isset($option['route_wp_mail_to_ses']) || $option['route_wp_mail_to_ses'] !== 'enabled':
                echo 'Tester Unvailable: "Route All wp_mail() Emails to AWS SES" must be Enabled.';
                return '';
            case empty($option['verified_email_identities']):
                echo 'Tester Unvailable: No "Verified Email Identities".';
                return '';
            case !defined('NANOMAILER_AWS_ACCESS_KEY') || empty(NANOMAILER_AWS_ACCESS_KEY):
                echo 'Tester Unvailable: "NANOMAILER_AWS_ACCESS_KEY" is undefined or empty.';
                return '';
            case !defined('NANOMAILER_AWS_SECRET_KEY') || empty(NANOMAILER_AWS_SECRET_KEY):
                echo 'Tester Unvailable: "NANOMAILER_AWS_SECRET_KEY" is undefined or empty.';
                return '';
            case empty($option['region']):
                echo 'Tester Unvailable: No "Region" selected.';
                return '';
            case !is_email($admin_email):
                echo 'Tester Unvailable: No valid admin email found. Please set in WordPress Settings > General > Administration Email Address.';
                return '';
        }
        $verified_email_identities = array_map( 'trim', explode(',', $option['verified_email_identities']) );
        ob_start();
        ?>
        <select id="verified_email_tester">
            <option value="">Send from...</option>
            <?php foreach( $verified_email_identities as $email ): ?>
                <option value="<?php echo esc_attr($email); ?>"><?php echo esc_attr($email); ?></option>
            <?php endforeach; ?>
        </select>
        <button id="expandops_nanomailer_start_test" class="button" type="button">Start Test</button>
        <p class="description">Select the verified email that the test will be sent <strong>from</strong> in the field above. The test will be sent <strong>to</strong> the site admin email: <strong><?php echo esc_attr( $admin_email ); ?></strong></p>
        <h4 >Test Output</h4>
        <div id="expandops_nanomailer_test_output_target" class="nanomailer-test-output">
            <p>Select an email and click Start Test to begin. Full step-by-step output will be shown here.</p>
        </div>
        <?php
        return ob_get_clean();
    } 
} 