<?php
namespace ExpandOps\Nanomailer\Fields;
defined( 'ABSPATH' ) || exit;
use ExpandOps\Nanomailer\Utilities\Log;
use ExpandOps\Nanomailer\Config;
class ActivityRecordField
{
    public static function render()
    {
        $option = get_option('expandops_nanomailer', []);
        $activity_record = $option['activity_record'] ?? [];
        ob_start();
        ?>       
        <div class="nanomailer-activity-record">
            <?php if (!empty($activity_record)) : ?>
                <?php foreach ($activity_record as $record) : ?>
                    <?php $record = (string) $record; ?>
                    <div class="record"><?php echo wp_kses_post( self::highlightStatus( $record ) ); ?></div>
                <?php endforeach; ?>
            <?php else : ?>
                <p>No Nanomailer activity has been logged. If activity was expected check all settings are correct and/or review the error log.</p>
            <?php endif; ?>
        </div>
        <p class="description">The activity log shows an overview of the 20 most recent emails that Nanomailer has processed. <strong>Refresh the page to see new records.</strong><p>
        <?php
        return ob_get_clean();
    } 
    private static function highlightStatus( $text )
    {
        return str_replace(
            ['SUCCESS', 'WARNING', 'ERROR', 'INFO'],
            [
                '<span class="success">SUCCESS</span>',
                '<span class="warning">WARNING</span>',
                '<span class="error">ERROR</span>',
                '<span class="info">INFO</span>'
            ],
            (string) $text
        );
    }
} 