<?php
namespace ExpandOps\Nanomailer;
defined('ABSPATH') || exit;
class Config
{
    private static $config = [];
    public static function load()
    {
        if ( !empty(self::$config) )
        {
            return; 
        }
        $base_dir = dirname(__DIR__);
        $default_config = file_exists($base_dir . '/lib/config/app.php') ? require $base_dir . '/lib/config/app.php' : [];
        $app_config = file_exists($base_dir . '/app/config/app.php') ? require $base_dir . '/app/config/app.php' : [];
        self::$config = array_merge($default_config, $app_config);
    }
    public static function get( $key = null, $default = null )
    {
        if ($key === null)
        {
            return self::$config; 
        }
        if( $key === 'upload_subdir_path' && !empty(self::$config[$key]) )
        {
            if ( ! file_exists(self::$config[$key]) ) 
            {
                wp_mkdir_p( self::$config[$key] );
            }
        }
        return self::$config[$key] ?? $default;
    }
}