<?php
/**
 * Uninstall AI Smart 404 Redirect
 *
 * @package AISmartRedirect
 * @author Prakhar Bhatia <prakhar@nandann.com>
 * @copyright 2025 Nandann Creative Agency
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
	exit;
}

// Delete plugin options
delete_option('nandann_smart_ai_404_redirect_options');

// Delete database table
global $wpdb;
$table_name = $wpdb->prefix . 'nandann_smart_ai_404_redirects';
$escaped_table = esc_sql( $table_name );
// phpcs:disable WordPress.DB.DirectDatabaseQuery, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
$wpdb->query( "DROP TABLE IF EXISTS {$escaped_table}" ); // Intentional schema change during uninstall
// phpcs:enable WordPress.DB.DirectDatabaseQuery, WordPress.DB.PreparedSQL.InterpolatedNotPrepared

// Clear scheduled events
wp_clear_scheduled_hook('nandann_smart_ai_404_cleanup_old_logs');
wp_clear_scheduled_hook('nandann_smart_ai_404_send_email_report_daily');
wp_clear_scheduled_hook('nandann_smart_ai_404_send_email_report_weekly');
wp_clear_scheduled_hook('nandann_smart_ai_404_send_email_report_monthly');

