<?php
/**
 * Help Tab / Questions & Suggestions Page Content
 */

function nandann_smart_ai_404_render_help_tab_content() {
    ?>
    <div class="aismart404-help-container">
        <!-- Main Content (Left Column - 68%) -->
        <div class="aismart404-main-content">
            
            <!-- NANDANN Promo at Top -->
            <div class="aismart404-card aismart404-nandann-promo">
                <div class="aismart404-card-body" style="text-align: center; padding: 40px 30px;">
                    <div class="aismart404-nandann-logo" style="margin-bottom: 20px;">
                        <img src="<?php echo esc_url(plugins_url('assets/nandann-logo.png', dirname(__FILE__))); ?>" alt="Nandann" style="max-width: 200px; height: auto;">
                    </div>
                    <p style="color: #7f8c8d; font-size: 12px; letter-spacing: 3px; margin: 0 0 20px 0; text-transform: uppercase; font-weight: 600;">Creative Agency</p>
                    
                    <h3 style="font-size: 24px; color: #2c3e50; margin: 0 0 10px 0; font-weight: 700;"><?php esc_html_e('Professional WordPress Development & Troubleshooting', 'nandann-ai-smart-404-redirect'); ?></h3>
                    <p style="color: #95a5a6; font-size: 15px; margin: 0 0 25px 0; font-style: italic;"><?php esc_html_e('Expert solutions for complex WordPress challenges', 'nandann-ai-smart-404-redirect'); ?></p>
                    
                    <p style="color: #555; line-height: 1.8; margin-bottom: 25px; font-size: 14px;">
                        <?php esc_html_e('Facing WordPress challenges? Get professional help from an experienced developer who understands the complexities of WordPress development and can provide reliable, efficient solutions.', 'nandann-ai-smart-404-redirect'); ?>
                    </p>
                    
                    <div style="margin-bottom: 20px;">
                        <a href="mailto:prakhar@nandann.com" class="button button-primary" style="background: #667eea; border: none; padding: 12px 30px; font-size: 15px; font-weight: 600; text-decoration: none; display: inline-flex; align-items: center; justify-content: center; flex-direction: column; margin-bottom: 12px; min-width: 200px; line-height: 1.4;">
                            <span style="display: flex; align-items: center; gap: 8px;">
                                <span class="dashicons dashicons-email-alt"></span>
                                <span><?php esc_html_e('Get Expert Help', 'nandann-ai-smart-404-redirect'); ?></span>
                            </span>
                            <span style="font-size: 13px; opacity: 0.9; margin-top: 4px;">prakhar@nandann.com</span>
                        </a>
                    </div>
                    
                    <div>
                        <a href="https://nandann.com" target="_blank" class="button" style="padding: 12px 30px; font-size: 15px; font-weight: 600; border: 2px solid #667eea; color: #667eea; text-decoration: none; display: inline-flex; align-items: center; justify-content: center; gap: 8px; min-width: 200px;">
                            <span class="dashicons dashicons-external"></span>
                            <span><?php esc_html_e('Visit nandann.com', 'nandann-ai-smart-404-redirect'); ?></span>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Service Cards Grid -->
            <div class="aismart404-services-grid">
                <div class="aismart404-card">
                    <div class="aismart404-card-body" style="text-align: center; padding: 25px 20px;">
                        <div style="font-size: 40px; color: #667eea; margin-bottom: 15px;">🔧</div>
                        <h4 style="margin: 0 0 10px 0; font-size: 16px; font-weight: 700; color: #2c3e50;"><?php esc_html_e('WordPress Troubleshooting', 'nandann-ai-smart-404-redirect'); ?></h4>
                        <p style="margin: 0; font-size: 13px; color: #7f8c8d; line-height: 1.6;"><?php esc_html_e('Expert diagnosis and resolution of complex WordPress issues, performance optimization, and security hardening.', 'nandann-ai-smart-404-redirect'); ?></p>
                    </div>
                </div>
                
                <div class="aismart404-card">
                    <div class="aismart404-card-body" style="text-align: center; padding: 25px 20px;">
                        <div style="font-size: 40px; color: #667eea; margin-bottom: 15px;">💻</div>
                        <h4 style="margin: 0 0 10px 0; font-size: 16px; font-weight: 700; color: #2c3e50;"><?php esc_html_e('Custom Development', 'nandann-ai-smart-404-redirect'); ?></h4>
                        <p style="margin: 0; font-size: 13px; color: #7f8c8d; line-height: 1.6;"><?php esc_html_e('Bespoke WordPress plugins, themes, and custom functionality tailored to your specific business needs.', 'nandann-ai-smart-404-redirect'); ?></p>
                    </div>
                </div>
                
                <div class="aismart404-card">
                    <div class="aismart404-card-body" style="text-align: center; padding: 25px 20px;">
                        <div style="font-size: 40px; color: #667eea; margin-bottom: 15px;">🚀</div>
                        <h4 style="margin: 0 0 10px 0; font-size: 16px; font-weight: 700; color: #2c3e50;"><?php esc_html_e('Site Migration & Hosting', 'nandann-ai-smart-404-redirect'); ?></h4>
                        <p style="margin: 0; font-size: 13px; color: #7f8c8d; line-height: 1.6;"><?php esc_html_e('Seamless website migrations, hosting optimization, and server configuration for peak performance.', 'nandann-ai-smart-404-redirect'); ?></p>
                    </div>
                </div>
                
                <div class="aismart404-card">
                    <div class="aismart404-card-body" style="text-align: center; padding: 25px 20px;">
                        <div style="font-size: 40px; color: #667eea; margin-bottom: 15px;">🔒</div>
                        <h4 style="margin: 0 0 10px 0; font-size: 16px; font-weight: 700; color: #2c3e50;"><?php esc_html_e('Security & Maintenance', 'nandann-ai-smart-404-redirect'); ?></h4>
                        <p style="margin: 0; font-size: 13px; color: #7f8c8d; line-height: 1.6;"><?php esc_html_e('Comprehensive security audits, malware removal, and ongoing maintenance to keep your site secure.', 'nandann-ai-smart-404-redirect'); ?></p>
                    </div>
                </div>
            </div>
            
        </div>
        
        <!-- Right Sidebar (30%) - Contact Form -->
        <div class="aismart404-sidebar">
            <div class="aismart404-card aismart404-sidebar-card">
                <div class="aismart404-card-header">
                    <h3><span class="dashicons dashicons-email"></span> <?php esc_html_e('Send Us a Message', 'nandann-ai-smart-404-redirect'); ?></h3>
                </div>
                <div class="aismart404-card-body">
                    <p style="font-size: 14px; margin-bottom: 20px;"><?php esc_html_e('Have questions, suggestions, or need support? Send us a message below and we\'ll get back to you soon.', 'nandann-ai-smart-404-redirect'); ?></p>
                    
                    <form id="aismart404-contact-form" class="aismart404-contact-form">
                        <?php wp_nonce_field('nandann_smart_ai_404_contact_nonce', 'nandann_smart_ai_404_contact_nonce'); ?>
                        
                        <div class="aismart404-form-group">
                            <label for="contact_name"><?php esc_html_e('Your Name', 'nandann-ai-smart-404-redirect'); ?> <span class="required">*</span></label>
                            <input type="text" id="contact_name" name="contact_name" class="regular-text" required placeholder="<?php esc_attr_e('Enter your name', 'nandann-ai-smart-404-redirect'); ?>">
                        </div>
                        
                        <div class="aismart404-form-group">
                            <label for="contact_email"><?php esc_html_e('Your Email', 'nandann-ai-smart-404-redirect'); ?> <span class="required">*</span></label>
                            <input type="email" id="contact_email" name="contact_email" class="regular-text" required placeholder="<?php esc_attr_e('Enter your email', 'nandann-ai-smart-404-redirect'); ?>">
                        </div>
                        
                        <div class="aismart404-form-group">
                            <label for="contact_message"><?php esc_html_e('Message', 'nandann-ai-smart-404-redirect'); ?> <span class="required">*</span></label>
                            <textarea id="contact_message" name="contact_message" rows="5" class="large-text" required placeholder="<?php esc_attr_e('Type your message...', 'nandann-ai-smart-404-redirect'); ?>"></textarea>
                        </div>
                        
                        <div class="aismart404-form-actions">
                            <button type="submit" class="button button-primary aismart404-submit-contact" style="width: 100%; display: flex; align-items: center; justify-content: center; gap: 8px;">
                                <span class="dashicons dashicons-email-alt" style="margin-top: 0;"></span>
                                <span><?php esc_html_e('Send Message', 'nandann-ai-smart-404-redirect'); ?></span>
                            </button>
                            <div class="aismart404-contact-status" style="margin-top: 10px;"></div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php
}

