/**
 * AI Smart 404 Redirect - Admin Scripts
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        /**
         * Test Email Button
         */
        $('.aismart404-test-email').on('click', function(e) {
            e.preventDefault();
            
            var $button = $(this);
            var $result = $('.aismart404-test-email-result');
            var email = $button.data('email');
            
            // Disable button and show loading
            $button.prop('disabled', true);
            $button.html('<span class="aismart404-spinner"></span> Sending...');
            $result.html('');
            
            $.ajax({
                url: aismart404Ajax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'nandann_smart_ai_404_test_email',
                    nonce: aismart404Ajax.nonce,
                    email: email
                },
                success: function(response) {
                    if (response.success) {
                        $result.html('<span class="aismart404-message aismart404-message-success">✓ ' + response.data + '</span>');
                    } else {
                        $result.html('<span class="aismart404-message aismart404-message-error">✗ ' + response.data + '</span>');
                    }
                },
                error: function() {
                    $result.html('<span class="aismart404-message aismart404-message-error">✗ Failed to send email</span>');
                },
                complete: function() {
                    // Re-enable button
                    $button.prop('disabled', false);
                    $button.html('<span class="dashicons dashicons-email-alt"></span> Send Test Email');
                    
                    // Clear message after 5 seconds
                    setTimeout(function() {
                        $result.fadeOut(function() {
                            $(this).html('').show();
                        });
                    }, 5000);
                }
            });
        });
        
        /**
         * Clear Logs Button
         */
        $('.aismart404-clear-logs').on('click', function(e) {
            e.preventDefault();
            
            if (!confirm('Are you sure you want to clear all logs? This action cannot be undone.')) {
                return;
            }
            
            var $button = $(this);
            
            // Disable button and show loading
            $button.prop('disabled', true);
            $button.html('<span class="aismart404-spinner"></span> Clearing...');
            
            $.ajax({
                url: aismart404Ajax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'nandann_smart_ai_404_clear_logs',
                    nonce: aismart404Ajax.nonce
                },
                success: function(response) {
                    if (response.success) {
                        // Reload the page to show empty logs
                        location.reload();
                    } else {
                        alert('Failed to clear logs: ' + response.data);
                        $button.prop('disabled', false);
                        $button.html('<span class="dashicons dashicons-trash"></span> Clear All Logs');
                    }
                },
                error: function() {
                    alert('An error occurred while clearing logs');
                    $button.prop('disabled', false);
                    $button.html('<span class="dashicons dashicons-trash"></span> Clear All Logs');
                }
            });
        });
        
        /**
         * Form Validation
         */
        $('.aismart404-settings-form').on('submit', function(e) {
            var fallbackUrl = $('input[name="fallback_url"]').val();
            var emailRecipient = $('input[name="email_recipient"]').val();
            
            // Validate fallback URL
            if (fallbackUrl && !isValidUrl(fallbackUrl)) {
                e.preventDefault();
                alert('Please enter a valid fallback URL');
                $('input[name="fallback_url"]').focus();
                return false;
            }
            
            // Validate email
            if (emailRecipient && !isValidEmail(emailRecipient)) {
                e.preventDefault();
                alert('Please enter a valid email address');
                $('input[name="email_recipient"]').focus();
                return false;
            }
        });
        
        /**
         * Redirect Method Change Handler
         */
        $('select[name="redirect_method"]').on('change', function() {
            var method = $(this).val();
            var $fallbackRow = $('input[name="fallback_url"]').closest('tr');
            
            if (method === 'custom') {
                $fallbackRow.show();
            } else {
                $fallbackRow.hide();
            }
        }).trigger('change');
        
        /**
         * Smooth Scroll for Anchor Links
         */
        $('a[href^="#"]').on('click', function(e) {
            var target = $(this.hash);
            if (target.length) {
                e.preventDefault();
                $('html, body').animate({
                    scrollTop: target.offset().top - 100
                }, 500);
            }
        });
        
        /**
         * Auto-hide Success Messages
         */
        $('.notice.is-dismissible').delay(5000).fadeOut(300);
        
        /**
         * Contact Form Submission
         */
        $('#aismart404-contact-form').on('submit', function(e) {
            e.preventDefault();
            
            var $form = $(this);
            var $button = $('.aismart404-submit-contact');
            var $status = $('.aismart404-contact-status');
            
            // Validate fields
            var name = $('#contact_name').val().trim();
            var email = $('#contact_email').val().trim();
            var message = $('#contact_message').val().trim();
            
            if (!name || !email || !message) {
                $status.removeClass('success').addClass('error').text('Please fill in all fields.');
                return;
            }
            
            if (!isValidEmail(email)) {
                $status.removeClass('success').addClass('error').text('Please enter a valid email address.');
                return;
            }
            
            // Disable button and show loading
            $button.prop('disabled', true).html('<span class="aismart404-spinner"></span> Sending...');
            $status.removeClass('success error').text('');
            
            $.ajax({
                url: aismart404Ajax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'nandann_smart_ai_404_submit_contact',
                    nonce: $('#aismart404_contact_nonce').val(),
                    name: name,
                    email: email,
                    message: message
                },
                success: function(response) {
                    if (response.success) {
                        $status.removeClass('error').addClass('success').text('✓ ' + response.data);
                        $form[0].reset();
                    } else {
                        $status.removeClass('success').addClass('error').text('✗ ' + response.data);
                    }
                },
                error: function() {
                    $status.removeClass('success').addClass('error').text('✗ Failed to send message. Please try again.');
                },
                complete: function() {
                    $button.prop('disabled', false).html('<span class="dashicons dashicons-email-alt"></span> Send Message');
                    
                    // Clear status after 5 seconds
                    setTimeout(function() {
                        $status.fadeOut(function() {
                            $(this).removeClass('success error').text('').show();
                        });
                    }, 5000);
                }
            });
        });
        
    });
    
    /**
     * Helper Functions
     */
    
    function isValidUrl(string) {
        try {
            new URL(string);
            return true;
        } catch (_) {
            return false;
        }
    }
    
    function isValidEmail(email) {
        var regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return regex.test(email);
    }
    
})(jQuery);

