<?php
defined('ABSPATH') || exit;
do_action('woocommerce_before_customer_login_form');
?>
<div class="ceovw-card-wrap">
  <div class="ceovw-card">
    <div class="ceovw-login-header"><?php echo wp_kses_post( get_option( 'naimur-email-otp-for-woocommerce_login_header_html', '<p class="ceovw-muted">Please enter your details</p><h1>Welcome back</h1>' ) ); ?></div>
    <div id="ceovw-auth-views" class="ceovw-auth-views">
      <div id="ceovw-view-login" class="ceovw-view" >
        <form class="woocommerce-form woocommerce-form-login login" method="post">
          <?php do_action('woocommerce_login_form_start'); ?>
          <div class="ceovw-field">
            <label for="username"><?php esc_html_e('Email address','naimur-email-otp-for-woocommerce'); ?> <span class="required">*</span></label>
            <input type="text" class="woocommerce-Input input-text" name="username" id="username" autocomplete="username" />
          </div>
          <div class="ceovw-field">
            <label for="password"><?php esc_html_e('Password','naimur-email-otp-for-woocommerce'); ?> <span class="required">*</span></label>
            <input class="woocommerce-Input input-text" type="password" name="password" id="password" autocomplete="current-password" />
          </div>
          <?php do_action('woocommerce_login_form'); ?>
          <div class="ceovw-actions">
            <label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
              <input class="woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever"> <span><?php esc_html_e('Remember for 30 days','naimur-email-otp-for-woocommerce'); ?></span>
            </label>
            <p class="woocommerce-LostPassword lost_password ceovw-small"><a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e('Forgot password','naimur-email-otp-for-woocommerce'); ?></a></p>
          </div>
          <div class="ceovw-field"><?php if ( get_option('naimur-email-otp-for-woocommerce_recaptcha_enabled',0) && get_option('naimur-email-otp-for-woocommerce_recaptcha_site_key') ) : ?><div class="g-recaptcha" data-sitekey="<?php echo esc_attr(get_option('naimur-email-otp-for-woocommerce_recaptcha_site_key')); ?>" data-callback="ceovwCaptchaFilled"></div><?php endif; ?></div>
          <p class="form-row">
            <?php wp_nonce_field('woocommerce-login','woocommerce-login-nonce'); ?>
            <button type="submit" class="woocommerce-button button ceovw-primary" name="login" value="<?php echo esc_attr__('Log in','naimur-email-otp-for-woocommerce'); ?>"><?php esc_html_e('Sign in','naimur-email-otp-for-woocommerce'); ?></button>
          </p>
          <?php do_action('woocommerce_login_form_end'); ?>
        </form>
        <p class="ceovw-small ceovw-switch"><?php esc_html_e("Don't have an account?",'naimur-email-otp-for-woocommerce'); ?> <a href="#" data-switch="register"><?php esc_html_e('Create account','naimur-email-otp-for-woocommerce'); ?></a></p>
      </div>

      <div id="ceovw-view-register" class="ceovw-view" hidden>
        <div class="ceovw-register-header"><?php echo wp_kses_post( get_option( 'naimur-email-otp-for-woocommerce_register_header_html', '<h1>Create your account</h1>' ) ); ?></div>
        <?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')) : ?>
          <form method="post" class="woocommerce-form woocommerce-form-register register">
            <?php do_action('woocommerce_register_form_start'); ?>
            <?php if ('no' === get_option('woocommerce_registration_generate_username')) : ?>
            <p class="ceovw-field"><label for="reg_username"><?php esc_html_e('Username','naimur-email-otp-for-woocommerce'); ?> <span class="required">*</span></label><input type="text" class="woocommerce-Input input-text" name="username" id="reg_username" autocomplete="username" /></p>
            <?php endif; ?>
            <p class="ceovw-field"><label for="reg_email"><?php esc_html_e('Email address','naimur-email-otp-for-woocommerce'); ?> <span class="required">*</span></label><input type="email" class="woocommerce-Input input-text" name="email" id="reg_email" autocomplete="email" /></p>
            <?php if ('no' === get_option('woocommerce_registration_generate_password')) : ?>
              <p class="ceovw-field"><label for="reg_password"><?php esc_html_e('Password','naimur-email-otp-for-woocommerce'); ?> <span class="required">*</span></label><input type="password" class="woocommerce-Input input-text" name="password" id="reg_password" autocomplete="new-password" /></p>
              <p class="ceovw-field"><label for="reg_password2"><?php esc_html_e('Confirm password','naimur-email-otp-for-woocommerce'); ?> <span class="required">*</span></label><input type="password" class="woocommerce-Input input-text" name="password2" id="reg_password2" autocomplete="new-password" /></p>
            <?php else : ?>
              <p class="ceovw-muted"><?php esc_html_e('A password will be sent to your email address.','naimur-email-otp-for-woocommerce'); ?></p>
            <?php endif; ?>
            <?php do_action('woocommerce_register_form'); ?>
            <div class="ceovw-field"><?php if ( get_option('naimur-email-otp-for-woocommerce_recaptcha_enabled',0) && get_option('naimur-email-otp-for-woocommerce_recaptcha_site_key') ) : ?><div class="g-recaptcha" data-sitekey="<?php echo esc_attr(get_option('naimur-email-otp-for-woocommerce_recaptcha_site_key')); ?>" data-callback="ceovwCaptchaFilled"></div><?php endif; ?></div>
            <p class="woocommerce-FormRow form-row">
              <?php wp_nonce_field('naimur-email-otp-for-woocommerce_nonce','naimur-email-otp-for-woocommerce_nonce'); ?>
              <button type="submit" class="woocommerce-Button button ceovw-primary" name="register" value="<?php echo esc_attr__('Register','naimur-email-otp-for-woocommerce'); ?>"><?php esc_html_e('Sign up','naimur-email-otp-for-woocommerce'); ?></button>
            </p>
            <?php do_action('woocommerce_register_form_end'); ?>
          </form>
          <p class="ceovw-small ceovw-switch"><a href="#" data-switch="login"><?php esc_html_e('Back to sign in','naimur-email-otp-for-woocommerce'); ?></a></p>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<script>
(function(){
  var ctaLinks=document.querySelectorAll('.ceovw-switch a');
  ctaLinks.forEach(function(a){
    a.addEventListener('click',function(e){
      e.preventDefault();
      var target=a.getAttribute('data-switch');
      var login=document.getElementById('ceovw-view-login');
      var reg=document.getElementById('ceovw-view-register');
      if(target==='register'){ login.hidden=true; reg.hidden=false; }
      else { reg.hidden=true; login.hidden=false; }
      window.scrollTo({top:0, behavior:'smooth'});
    });
  });
})();
</script>
<?php do_action('woocommerce_after_customer_login_form'); ?>