<?php
/**
 * Plugin Name: Naimur Email OTP Verification for WooCommerce
 * Plugin URI: https://naimurrahmannahid.com/naimur-otp-plugin/
 * Description: Verify WooCommerce customer emails using a 6-digit OTP before account creation. Includes optional Google reCAPTCHA, email logs, activity tracking, and a responsive popup design.
 * Version: 1.1.6
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 * Author: Naimur Rahman Nahid
 * Author URI: https://naimurrahmannahid.com/
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: naimur-email-otp-for-woocommerce
 * Domain Path: /languages
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

define('NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_VERSION', '1.1.5');
define('NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH', plugin_dir_path(__FILE__));
define('NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_URL', plugin_dir_url(__FILE__));

// Includes
require_once NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'includes/helpers.php';
require_once NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'includes/class-settings.php';
require_once NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'includes/class-emails.php';
require_once NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'includes/class-ajax.php';
require_once NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'includes/class-users.php';
require_once NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'includes/class-override.php';
require_once NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'includes/class-security.php';
require_once NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'includes/class-logs.php';

// Assets only when needed
add_action('wp_enqueue_scripts', function() {
    $override_enabled = (bool) get_option('naimur-email-otp-for-woocommerce_override_enabled', false);
    $my_page_id       = (int) get_option('naimur-email-otp-for-woocommerce_myaccount_page_id', 0);

    $should_enqueue = false;
    if (function_exists('is_account_page') && is_account_page()) { $should_enqueue = true; }
    if ($override_enabled && $my_page_id && is_page($my_page_id)) { $should_enqueue = true; }
    if (!$should_enqueue) return;

    wp_enqueue_style('naimur-email-otp-for-woocommerce-css', NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_URL.'assets/css/modal.css', [], NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_VERSION);
    if ( get_option('naimur-email-otp-for-woocommerce_recaptcha_enabled', 0) && get_option('naimur-email-otp-for-woocommerce_recaptcha_site_key') ) {
        wp_enqueue_script('google-recaptcha','https://www.google.com/recaptcha/api.js',[],NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_VERSION,true);
    }
    wp_enqueue_script('naimur-email-otp-for-woocommerce-boot', NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_URL.'assets/js/boot.js', [], NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_VERSION, true);
    wp_enqueue_script('naimur-email-otp-for-woocommerce-js', NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_URL.'assets/js/main.js', ['jquery'], NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_VERSION, true);
    wp_localize_script('naimur-email-otp-for-woocommerce-js', 'CEOVW', [
        'ajax'      => admin_url('admin-ajax.php'),
        'nonce'     => wp_create_nonce('naimur-email-otp-for-woocommerce_nonce'),
        'i18n'      => [
            'enter_code' => esc_html__('Enter the 6-digit code sent to', 'naimur-email-otp-for-woocommerce'),
            'resend'     => esc_html__('Resend code', 'naimur-email-otp-for-woocommerce'),
            'verify'     => esc_html__('Verify & Create Account', 'naimur-email-otp-for-woocommerce'),
            'invalid'    => esc_html__('Invalid or expired code. Try again.', 'naimur-email-otp-for-woocommerce'),
        ],
        'settings'  => [
            'code_length' => (int) get_option('naimur-email-otp-for-woocommerce_code_length', 6),
            'cooldown'    => (int) get_option('naimur-email-otp-for-woocommerce_resend_cooldown', 60),
        ],
    ]);
});

// Extra name field on register form
add_action('woocommerce_register_form', function(){
    echo '<p class="form-row form-row-wide">'
        .'<label for="ceovw_full_name">'.esc_html__('Full name', 'naimur-email-otp-for-woocommerce').' <span class="required">*</span></label>'
        .'<input type="text" class="input-text" name="ceovw_full_name" id="ceovw_full_name" value="" required />'
        .'</p>';
});

// OTP modal markup
add_action('wp_footer', function(){
    if (!function_exists('is_account_page') || !is_account_page()) return;
    include NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'templates/modal.php';
});

// Quick Settings links
add_filter('plugin_action_links_'.plugin_basename(__FILE__), function($links){
    $links[] = '<a href="'.esc_url(admin_url('admin.php?page=naimur-email-otp-for-woocommerce-settings')).'">'.esc_html__('Settings', 'naimur-email-otp-for-woocommerce').'</a>';
    $links[] = '<a href="'.esc_url(admin_url('admin.php?page=naimur-email-otp-for-woocommerce-logs')).'">'.esc_html__('Logs', 'naimur-email-otp-for-woocommerce').'</a>';
    return $links;
});