<?php
if (!defined('ABSPATH')) { exit; }

function ceovw_generate_code($length = 6){
    $length = max(4, min(8, (int) $length));
    $min = (int) str_pad('1', $length, '0');
    $max = (int) str_pad('', $length, '9');
    return (string) wp_rand($min, $max);
}
function ceovw_storage_key($email){ return 'ceovw_'.md5(strtolower(trim($email))); }
function ceovw_store_pending($email, $payload, $code){
    $expiry = (int) get_option('naimur-email-otp-for-woocommerce_code_expiry', 10);
    $data = [ 'code'=>$code, 'payload'=>$payload, 'created'=>time(), 'attempts'=>0 ];
    set_transient(ceovw_storage_key($email), $data, $expiry * MINUTE_IN_SECONDS);
}
function ceovw_get_pending($email){ return get_transient(ceovw_storage_key($email)); }
function ceovw_update_pending($email, $data){ set_transient(ceovw_storage_key($email), $data, (int) get_option('naimur-email-otp-for-woocommerce_code_expiry',10) * MINUTE_IN_SECONDS); }
function ceovw_clear_pending($email){ delete_transient(ceovw_storage_key($email)); }
