<?php
if (!defined('ABSPATH')) { exit; }

class CEOVW_Settings {
    public static function init(){
        add_action('admin_menu', [__CLASS__, 'menu']);
        add_action('admin_init', [__CLASS__, 'register']);
        add_shortcode('naimur_email_otp_code', [__CLASS__, 'shortcode_code']);
        add_action('wp_ajax_ceovw_preview_template', [__CLASS__, 'preview_template']);
    }
    public static function menu(){
        add_submenu_page('woocommerce', esc_html__('Email Verification', 'naimur-email-otp-for-woocommerce'), esc_html__('Email Verification', 'naimur-email-otp-for-woocommerce'), 'manage_woocommerce', 'naimur-email-otp-for-woocommerce-settings', [__CLASS__, 'render']);
    }
    public static function register(){
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_email_subject', ['sanitize_callback' => 'sanitize_text_field']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_email_template', ['sanitize_callback' => 'sanitize_text_field']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_brand_color', ['sanitize_callback' => 'sanitize_hex_color']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_brand_logo', ['sanitize_callback' => 'esc_url_raw']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_code_length', ['sanitize_callback' => 'absint']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_code_expiry', ['sanitize_callback' => 'absint']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_resend_cooldown', ['sanitize_callback' => 'absint']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_override_enabled', ['sanitize_callback' => 'rest_sanitize_boolean']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_myaccount_page_id', ['sanitize_callback' => 'absint']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_recaptcha_enabled', ['sanitize_callback' => 'rest_sanitize_boolean']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_recaptcha_site_key', ['sanitize_callback' => 'sanitize_text_field']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_recaptcha_secret_key', ['sanitize_callback' => 'sanitize_text_field']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_login_header_html', ['sanitize_callback' => 'wp_kses_post']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_register_header_html', ['sanitize_callback' => 'wp_kses_post']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_email_html_1', ['sanitize_callback' => 'wp_kses_post']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_email_html_2', ['sanitize_callback' => 'wp_kses_post']);
        register_setting('naimur-email-otp-for-woocommerce', 'naimur-email-otp-for-woocommerce_email_html_3', ['sanitize_callback' => 'wp_kses_post']);
    }
    public static function render(){ ?>
        <div class="wrap">
            <h1><?php echo esc_html__('Customer Email OTP Verification for WooCommerce', 'naimur-email-otp-for-woocommerce'); ?></h1>
            <p><?php echo esc_html__('Use the shortcode', 'naimur-email-otp-for-woocommerce'); ?> <code>[naimur_email_otp_code]</code> <?php echo esc_html__('inside the email template to insert the verification code.', 'naimur-email-otp-for-woocommerce'); ?></p>
            <form method="post" action="options.php">
                <?php settings_fields('naimur-email-otp-for-woocommerce'); ?>
                <table class="form-table" role="presentation">
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_email_subject"><?php esc_html_e('Email subject', 'naimur-email-otp-for-woocommerce'); ?></label></th>
                        <td><input type="text" class="regular-text" name="naimur-email-otp-for-woocommerce_email_subject" id="naimur-email-otp-for-woocommerce_email_subject" value="<?php echo esc_attr(get_option('naimur-email-otp-for-woocommerce_email_subject', esc_html__('Your verification code', 'naimur-email-otp-for-woocommerce'))); ?>" /></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_email_template"><?php esc_html_e('Template', 'naimur-email-otp-for-woocommerce'); ?></label></th>
                        <td>
                            <select name="naimur-email-otp-for-woocommerce_email_template" id="naimur-email-otp-for-woocommerce_email_template">
                                <?php for($i=1;$i<=3;$i++): ?>
                                    <?php /* translators: %d = template number */ ?>
                                    <option value="<?php echo esc_attr( (string) $i ); ?>" <?php selected(get_option('naimur-email-otp-for-woocommerce_email_template','1'), (string)$i); ?>><?php echo esc_html( sprintf( __( 'Template %d', 'naimur-email-otp-for-woocommerce' ), (int) $i ) ); ?></option>
                                <?php endfor; ?>
                            </select>
                            <a href="<?php echo esc_url(admin_url('admin-ajax.php?action=ceovw_preview_template&_wpnonce='.wp_create_nonce('ceovw_preview'))); ?>" target="_blank" class="button"><?php esc_html_e('Preview', 'naimur-email-otp-for-woocommerce'); ?></a>
                            <p class="description"><?php esc_html_e('Edit the selected template HTML below. Use [naimur_email_otp_code] where the 6-digit code should appear.', 'naimur-email-otp-for-woocommerce'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_brand_color"><?php esc_html_e('Brand color (HEX)', 'naimur-email-otp-for-woocommerce'); ?></label></th>
                        <td><input type="text" class="regular-text" name="naimur-email-otp-for-woocommerce_brand_color" id="naimur-email-otp-for-woocommerce_brand_color" value="<?php echo esc_attr(get_option('naimur-email-otp-for-woocommerce_brand_color', '#111827')); ?>" placeholder="#111827" /></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_brand_logo"><?php esc_html_e('Logo URL', 'naimur-email-otp-for-woocommerce'); ?></label></th>
                        <td><input type="url" class="regular-text" name="naimur-email-otp-for-woocommerce_brand_logo" id="naimur-email-otp-for-woocommerce_brand_logo" value="<?php echo esc_attr(get_option('naimur-email-otp-for-woocommerce_brand_logo', '')); ?>" /></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_code_length"><?php esc_html_e('Code length', 'naimur-email-otp-for-woocommerce'); ?></label></th>
                        <td><input type="number" min="4" max="8" name="naimur-email-otp-for-woocommerce_code_length" id="naimur-email-otp-for-woocommerce_code_length" value="<?php echo esc_attr(get_option('naimur-email-otp-for-woocommerce_code_length', 6)); ?>" /></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_code_expiry"><?php esc_html_e('Code expiry (minutes)', 'naimur-email-otp-for-woocommerce'); ?></label></th>
                        <td><input type="number" min="3" max="60" name="naimur-email-otp-for-woocommerce_code_expiry" id="naimur-email-otp-for-woocommerce_code_expiry" value="<?php echo esc_attr(get_option('naimur-email-otp-for-woocommerce_code_expiry', 10)); ?>" /></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_resend_cooldown"><?php esc_html_e('Resend cooldown (seconds)', 'naimur-email-otp-for-woocommerce'); ?></label></th>
                        <td><input type="number" min="15" max="600" name="naimur-email-otp-for-woocommerce_resend_cooldown" id="naimur-email-otp-for-woocommerce_resend_cooldown" value="<?php echo esc_attr(get_option('naimur-email-otp-for-woocommerce_resend_cooldown', 60)); ?>" /></td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e('My Account override', 'naimur-email-otp-for-woocommerce'); ?></th>
                        <td>
                            <label><input type="checkbox" name="naimur-email-otp-for-woocommerce_override_enabled" value="1" <?php checked(get_option('naimur-email-otp-for-woocommerce_override_enabled', 0), 1); ?> /> <?php esc_html_e('Enable custom login/register design', 'naimur-email-otp-for-woocommerce'); ?></label><br/>
                            <label for="naimur-email-otp-for-woocommerce_myaccount_page_id"><?php esc_html_e('Select My Account page', 'naimur-email-otp-for-woocommerce'); ?></label><br/>
                            <?php
                                wp_dropdown_pages([
                                    'name'              => 'naimur-email-otp-for-woocommerce_myaccount_page_id',
                                    'id'                => 'naimur-email-otp-for-woocommerce_myaccount_page_id',
                                    'echo'              => 1,
                                    'show_option_none'  => esc_html__( '— Select —', 'naimur-email-otp-for-woocommerce' ),
                                    'option_none_value' => '0',
                                    'selected'          => (int) get_option('naimur-email-otp-for-woocommerce_myaccount_page_id', 0 ),
                                ]);
                            ?>
                            <p class="description"><?php esc_html_e('Choose the WooCommerce “My account” page, then check the override box and save. The plugin will only apply styles to that page.', 'naimur-email-otp-for-woocommerce'); ?></p>
                        </td>
                    </tr>
                    <tr>
                        <th><?php esc_html_e('Google reCAPTCHA', 'naimur-email-otp-for-woocommerce'); ?></th>
                        <td>
                            <label><input type="checkbox" name="naimur-email-otp-for-woocommerce_recaptcha_enabled" value="1" <?php checked(get_option('naimur-email-otp-for-woocommerce_recaptcha_enabled',0),1); ?> /> <?php esc_html_e('Enable reCAPTCHA (v2 Checkbox)', 'naimur-email-otp-for-woocommerce'); ?></label><br/>
                            <input type="text" class="regular-text" name="naimur-email-otp-for-woocommerce_recaptcha_site_key" placeholder="Site Key" value="<?php echo esc_attr( get_option('naimur-email-otp-for-woocommerce_recaptcha_site_key','') ); ?>" /><br/>
                            <input type="text" class="regular-text" name="naimur-email-otp-for-woocommerce_recaptcha_secret_key" placeholder="Secret Key" value="<?php echo esc_attr( get_option('naimur-email-otp-for-woocommerce_recaptcha_secret_key','') ); ?>" />
                        </td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_login_header_html"><?php esc_html_e( 'Login header HTML', 'naimur-email-otp-for-woocommerce' ); ?></label></th>
                        <td><?php wp_editor( get_option( 'naimur-email-otp-for-woocommerce_login_header_html', '<p class="ceovw-muted">Please enter your details</p><h1>Welcome back</h1>' ), 'naimur-email-otp-for-woocommerce_login_header_html', [ 'textarea_rows' => 5 ] ); ?></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_register_header_html"><?php esc_html_e( 'Register header HTML', 'naimur-email-otp-for-woocommerce' ); ?></label></th>
                        <td><?php wp_editor( get_option( 'naimur-email-otp-for-woocommerce_register_header_html', '<h1>Create your account</h1>' ), 'naimur-email-otp-for-woocommerce_register_header_html', [ 'textarea_rows' => 5 ] ); ?></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_email_html_1"><?php esc_html_e( 'Template 1 HTML', 'naimur-email-otp-for-woocommerce' ); ?></label></th>
                        <td><?php wp_editor( get_option( 'naimur-email-otp-for-woocommerce_email_html_1', '' ), 'naimur-email-otp-for-woocommerce_email_html_1', [ 'textarea_rows' => 10 ] ); ?></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_email_html_2"><?php esc_html_e( 'Template 2 HTML', 'naimur-email-otp-for-woocommerce' ); ?></label></th>
                        <td><?php wp_editor( get_option( 'naimur-email-otp-for-woocommerce_email_html_2', '' ), 'naimur-email-otp-for-woocommerce_email_html_2', [ 'textarea_rows' => 10 ] ); ?></td>
                    </tr>
                    <tr>
                        <th><label for="naimur-email-otp-for-woocommerce_email_html_3"><?php esc_html_e( 'Template 3 HTML', 'naimur-email-otp-for-woocommerce' ); ?></label></th>
                        <td><?php wp_editor( get_option( 'naimur-email-otp-for-woocommerce_email_html_3', '' ), 'naimur-email-otp-for-woocommerce_email_html_3', [ 'textarea_rows' => 10 ] ); ?></td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
            <hr />
            <p><a class="button" href="<?php echo esc_url( admin_url('admin.php?page=naimur-email-otp-for-woocommerce-logs') ); ?>"><?php esc_html_e('View Logs', 'naimur-email-otp-for-woocommerce'); ?></a></p>
        </div>
    <?php }

    public static function shortcode_code($atts, $content = ''){ return $content; }

    public static function preview_template(){
        check_admin_referer('ceovw_preview');
        if (!current_user_can('manage_woocommerce')) wp_die('-');
        $code      = '123456';
        $template  = get_option('naimur-email-otp-for-woocommerce_email_template', '1');
        $opt_html  = get_option('naimur-email-otp-for-woocommerce_email_html_' . $template, '');
        if (!empty($opt_html)) { echo do_shortcode( str_replace('[naimur_email_otp_code]', esc_html($code), wp_kses_post($opt_html)) ); }
        else { include NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'templates/email-template-'.$template.'.php'; }
        wp_die();
    }
}
CEOVW_Settings::init();
