<?php
if (!defined('ABSPATH')) { exit; }

class CEOVW_Security {
    public static function init(){
        add_filter('woocommerce_process_login_errors', [__CLASS__, 'validate_login_recaptcha'], 10, 3);
    }
    public static function is_recaptcha_enabled(){
        return (bool) get_option('naimur-email-otp-for-woocommerce_recaptcha_enabled', 0) && get_option('naimur-email-otp-for-woocommerce_recaptcha_site_key') && get_option('naimur-email-otp-for-woocommerce_recaptcha_secret_key');
    }
    public static function validate_login_recaptcha($errors, $username, $password){
        if (!self::is_recaptcha_enabled()) return $errors;

        // Verify WooCommerce login nonce if present (to satisfy Plugin Check)
        if ( isset($_POST['woocommerce-login-nonce']) ) {
            $n = sanitize_text_field( wp_unslash( $_POST['woocommerce-login-nonce'] ) );
            if ( ! wp_verify_nonce( $n, 'woocommerce-login' ) ) { return $errors; }
        }

        if (empty($_POST['g-recaptcha-response'])){ $errors->add('recaptcha', esc_html__('Please complete the reCAPTCHA.', 'naimur-email-otp-for-woocommerce')); return $errors; }
        $token = sanitize_text_field( wp_unslash($_POST['g-recaptcha-response']) );
        $ok = self::verify_recaptcha_token($token);
        if (!$ok){ $errors->add('recaptcha', esc_html__('reCAPTCHA verification failed.', 'naimur-email-otp-for-woocommerce')); }
        return $errors;
    }
    public static function verify_recaptcha_token($token){
        $secret = get_option('naimur-email-otp-for-woocommerce_recaptcha_secret_key');
        if (empty($secret)) return false;
        $ip = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : '';
        $response = wp_remote_post('https://www.google.com/recaptcha/api/siteverify', [
            'body' => [
                'secret'   => $secret,
                'response' => $token,
                'remoteip' => $ip
            ],
            'timeout' => 10,
        ]);
        if (is_wp_error($response)) {
            return false;
        }
        $body = json_decode(wp_remote_retrieve_body($response), true);
        if (empty($body['success'])) {
            return false;
        }
        return true;
    }
}
CEOVW_Security::init();