<?php
if (!defined('ABSPATH')) { exit; }

class CEOVW_Override {
    public static function init(){
        add_filter('woocommerce_locate_template', [__CLASS__, 'locate'], 10, 3);
        add_action('wp_enqueue_scripts', [__CLASS__, 'enqueue_override_css']);
    }
    public static function is_override_context(){
        $enabled = (bool) get_option('naimur-email-otp-for-woocommerce_override_enabled', false);
        $page_id = (int) get_option('naimur-email-otp-for-woocommerce_myaccount_page_id', 0);
        return $enabled && $page_id && is_page($page_id);
    }
    public static function locate($template, $template_name, $template_path){
        if (self::is_override_context() && in_array($template_name, ['myaccount/form-login.php'], true)){
            $custom = NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH.'templates/woocommerce/'.$template_name;
            if (file_exists($custom)) return $custom;
        }
        return $template;
    }
    public static function enqueue_override_css(){
        if (self::is_override_context()){
            wp_enqueue_style('naimur-email-otp-for-woocommerce-override', NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_URL.'assets/css/override-myaccount.css', [], NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_VERSION);
        }
    }
}
CEOVW_Override::init();
