<?php
if (!defined('ABSPATH')) { exit; }

class CEOVW_Logs {
    const EMAIL_T_KEY = 'ceovw_email_logs';
    const ACTIVITY_KEY = 'ceovw_activity_logs';
    const EMAIL_T_TTL = 7; // days

    public static function init(){ add_action('admin_menu', [__CLASS__, 'menu']); }
    public static function menu(){
        add_submenu_page('woocommerce', esc_html__('Email/Activity Logs', 'naimur-email-otp-for-woocommerce'), esc_html__('Email Verification Logs', 'naimur-email-otp-for-woocommerce'), 'manage_woocommerce', 'naimur-email-otp-for-woocommerce-logs', [__CLASS__, 'render']);
    }
    public static function get_email_logs(){ $logs = get_transient(self::EMAIL_T_KEY); return is_array($logs)?$logs:[]; }
    public static function push_email_log($entry){
        $logs = self::get_email_logs();
        $logs[] = $entry;
        if (count($logs) > 100) { $logs = array_slice($logs, -100); }
        set_transient(self::EMAIL_T_KEY, $logs, self::EMAIL_T_TTL * DAY_IN_SECONDS);
    }
    public static function get_activity_logs(){ $logs = get_option(self::ACTIVITY_KEY, []); return is_array($logs)?$logs:[]; }
    public static function push_activity_log($entry){
        $logs = self::get_activity_logs();
        $logs[] = $entry;
        if (count($logs) > 200) { $logs = array_slice($logs, -200); }
        update_option(self::ACTIVITY_KEY, $logs, false);
    }
    public static function render(){
        if (isset($_POST['ceovw_clear_logs']) && check_admin_referer('ceovw_logs')){
            if ($_POST['ceovw_clear_logs'] === 'email') { delete_transient(self::EMAIL_T_KEY); }
            if ($_POST['ceovw_clear_logs'] === 'activity') { update_option(self::ACTIVITY_KEY, [] ); }
            echo '<div class="updated"><p>'.esc_html__('Logs cleared.', 'naimur-email-otp-for-woocommerce').'</p></div>';
        }
        $email_logs = self::get_email_logs(); $activity = self::get_activity_logs(); ?>
        <div class="wrap">
            <h1><?php esc_html_e('Email & Activity Logs', 'naimur-email-otp-for-woocommerce'); ?></h1>
            <h2><?php esc_html_e('Last Sent OTP Emails', 'naimur-email-otp-for-woocommerce'); ?></h2>
            <form method="post"><?php wp_nonce_field('ceovw_logs'); ?><input type="hidden" name="ceovw_clear_logs" value="email" /><button class="button"><?php esc_html_e('Clear Email Logs','naimur-email-otp-for-woocommerce'); ?></button></form>
            <table class="widefat striped"><thead><tr><th><?php esc_html_e('Time','naimur-email-otp-for-woocommerce'); ?></th><th><?php esc_html_e('Email','naimur-email-otp-for-woocommerce'); ?></th><th><?php esc_html_e('Code','naimur-email-otp-for-woocommerce'); ?></th><th><?php esc_html_e('Status','naimur-email-otp-for-woocommerce'); ?></th><th><?php esc_html_e('Message','naimur-email-otp-for-woocommerce'); ?></th></tr></thead><tbody>
            <?php if (empty($email_logs)): ?><tr><td colspan="5"><?php esc_html_e('No logs yet.','naimur-email-otp-for-woocommerce'); ?></td></tr>
            <?php else: foreach (array_reverse($email_logs) as $row): ?>
                <tr>
                    <td><?php echo esc_html( date_i18n( get_option('date_format').' '.get_option('time_format'), $row['time'] ?? time() ) ); ?></td>
                    <td><?php echo esc_html($row['email'] ?? ''); ?></td>
                    <td><code><?php echo esc_html($row['code'] ?? ''); ?></code></td>
                    <td><?php echo esc_html($row['status'] ?? ''); ?></td>
                    <td><?php echo esc_html($row['message'] ?? ''); ?></td>
                </tr>
            <?php endforeach; endif; ?></tbody></table>

            <h2 style="margin-top:28px;"><?php esc_html_e('Activity (Who verified when)','naimur-email-otp-for-woocommerce'); ?></h2>
            <form method="post"><?php wp_nonce_field('ceovw_logs'); ?><input type="hidden" name="ceovw_clear_logs" value="activity" /><button class="button"><?php esc_html_e('Clear Activity Logs','naimur-email-otp-for-woocommerce'); ?></button></form>
            <table class="widefat striped"><thead><tr><th><?php esc_html_e('Time','naimur-email-otp-for-woocommerce'); ?></th><th><?php esc_html_e('User ID','naimur-email-otp-for-woocommerce'); ?></th><th><?php esc_html_e('Email','naimur-email-otp-for-woocommerce'); ?></th><th><?php esc_html_e('IP','naimur-email-otp-for-woocommerce'); ?></th></tr></thead><tbody>
            <?php if (empty($activity)): ?><tr><td colspan="4"><?php esc_html_e('No activity yet.','naimur-email-otp-for-woocommerce'); ?></td></tr>
            <?php else: foreach (array_reverse($activity) as $row): ?>
                <tr>
                    <td><?php echo esc_html( date_i18n( get_option('date_format').' '.get_option('time_format'), $row['time'] ?? time() ) ); ?></td>
                    <td><?php echo esc_html($row['user_id'] ?? ''); ?></td>
                    <td><?php echo esc_html($row['email'] ?? ''); ?></td>
                    <td><?php echo esc_html($row['ip'] ?? ''); ?></td>
                </tr>
            <?php endforeach; endif; ?></tbody></table>
        </div><?php
    }
}
CEOVW_Logs::init();
