<?php
if (!defined('ABSPATH')) { exit; }

class CEOVW_Emails {
    public static function send_code($email, $code){
        $subject  = get_option(
            'naimur-email-otp-for-woocommerce_email_subject',
            esc_html__('Your verification code', 'naimur-email-otp-for-woocommerce')
        );
        $template = get_option('naimur-email-otp-for-woocommerce_email_template', '1');
        $opt_html = get_option('naimur-email-otp-for-woocommerce_email_html_' . $template, '');

        // Support both the new shortcode and the legacy one to remain backward compatible.
        $search  = array('[naimur_email_otp_code]', '[wccev_code]');
        $replace = array(esc_html($code), esc_html($code));

        if (!empty($opt_html)) {
            $html = wp_kses_post($opt_html);
            $html = str_replace($search, $replace, $html);
            $html = do_shortcode($html);
        } else {
            ob_start();
            include NAIMUR_EMAIL_OTP_FOR_WOOCOMMERCE_PATH . 'templates/email-template-' . $template . '.php';
            $html = ob_get_clean();
            $html = str_replace($search, $replace, $html);
            $html = do_shortcode($html);
        }

        // Ensure the email is sent as HTML only for this email.
        $content_type_filter = function () {
            return 'text/html';
        };

        add_filter('wp_mail_content_type', $content_type_filter);
        $sent = wp_mail($email, $subject, $html, array());
        remove_filter('wp_mail_content_type', $content_type_filter);

        return $sent;
    }
}
