<?php
if (!defined('ABSPATH')) { exit; }

class CEOVW_Ajax {
    public static function init(){
        add_action('wp_ajax_nopriv_ceovw_send_code',  [__CLASS__, 'send_code']);
        add_action('wp_ajax_nopriv_ceovw_verify_code', [__CLASS__, 'verify_code']);
    }

    public static function send_code(){
        check_ajax_referer('naimur-email-otp-for-woocommerce_nonce', 'nonce');
        $email    = sanitize_email( wp_unslash( $_POST['email'] ?? '' ) );
        $name     = sanitize_text_field( wp_unslash( $_POST['name'] ?? '' ) );
        $password = sanitize_text_field( wp_unslash( $_POST['password'] ?? '' ) );
        $grept    = sanitize_text_field( wp_unslash( $_POST['g_recaptcha'] ?? '' ) );

        if (!is_email($email) || empty($name) || empty($password)){ wp_send_json_error(['message' => esc_html__('Invalid form data.', 'naimur-email-otp-for-woocommerce')]); }
        if (email_exists($email)){ wp_send_json_error(['message' => esc_html__('Email already registered. Please log in.', 'naimur-email-otp-for-woocommerce')]); }

        if ( CEOVW_Security::is_recaptcha_enabled() ){
            if ( empty($grept) || !CEOVW_Security::verify_recaptcha_token($grept) ) { wp_send_json_error(['message' => esc_html__('reCAPTCHA check failed.', 'naimur-email-otp-for-woocommerce')]); }
        }

        $code = ceovw_generate_code((int) get_option('naimur-email-otp-for-woocommerce_code_length', 6));

        ceovw_store_pending($email, [
            'email'    => $email,
            'name'     => $name,
            'password' => wp_hash_password($password),
        ], $code);

        $sent = CEOVW_Emails::send_code($email, $code);
        if (!$sent){
            CEOVW_Logs::push_email_log(['email'=>$email,'code'=>$code,'time'=>time(),'status'=>'failed','message'=>'wp_mail failed']);
            wp_send_json_error(['message' => esc_html__('Failed to send email. Contact support.', 'naimur-email-otp-for-woocommerce')]);
        }

        CEOVW_Logs::push_email_log(['email'=>$email,'code'=>$code,'time'=>time(),'status'=>'sent','message'=>'OK']);
        wp_send_json_success(['message' => esc_html__('Code sent. Check your inbox.', 'naimur-email-otp-for-woocommerce')]);
    }

    public static function verify_code(){
        check_ajax_referer('naimur-email-otp-for-woocommerce_nonce', 'nonce');
        $email = sanitize_email( wp_unslash( $_POST['email'] ?? '' ) );
        $code  = sanitize_text_field( wp_unslash( $_POST['code'] ?? '' ) );

        $pending = ceovw_get_pending($email);
        if (!$pending){ wp_send_json_error(['message' => esc_html__('No pending verification. Please resend code.', 'naimur-email-otp-for-woocommerce')]); }

        $pending['attempts'] = ($pending['attempts'] ?? 0) + 1;
        ceovw_update_pending($email, $pending);
        if ($pending['attempts'] > 10){ ceovw_clear_pending($email); wp_send_json_error(['message' => esc_html__('Too many attempts. Start over.', 'naimur-email-otp-for-woocommerce')]); }
        if ($code !== $pending['code']){ wp_send_json_error(['message' => esc_html__('Invalid or expired code.', 'naimur-email-otp-for-woocommerce')]); }

        $name     = sanitize_text_field( $pending['payload']['name'] ?? '' );
        $username = sanitize_user( current( explode('@', $email) ) );
        $user_id = wc_create_new_customer($email, $username, wp_generate_password(24));
        if (is_wp_error($user_id)){ wp_send_json_error(['message' => esc_html( $user_id->get_error_message() )]); }

        if (!empty($_POST['raw_password'])){ wp_set_password( sanitize_text_field( wp_unslash($_POST['raw_password']) ), $user_id); }
        update_user_meta($user_id, 'first_name', $name);
        update_user_meta($user_id, 'ceovw_verified', 1);

        if ( function_exists('wc_set_customer_auth_cookie') ) {
            wc()->customer = new WC_Customer($user_id);
            wc_set_customer_auth_cookie($user_id);
        }

        $ip = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : '';
        CEOVW_Logs::push_activity_log(['user_id'=>$user_id,'email'=>$email,'time'=>time(),'ip'=>$ip]);
        ceovw_clear_pending($email);
        wp_send_json_success(['redirect' => esc_url_raw( wc_get_page_permalink('myaccount') )]);
    }
}
CEOVW_Ajax::init();
