<?php
if (!defined('ABSPATH'))
    exit;

// Verificar permisos nuevamente
if (!current_user_can('manage_options')) {
    wp_die(esc_html__('No tienes permisos suficientes para acceder a esta página.', 'mz-calculate-fees'));
}

// phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound

global $wpdb;
$table_name = $wpdb->prefix . 'plst_cf_woo_cuotas';

// --- Lógica de Guardado ---
if (isset($_POST['plst_submit_add'])) {
    // Verificar CSRF (Nonce)
    check_admin_referer('plst_add_fee_action', 'plst_add_fee_nonce');

    // Sanitizar y validar datos de entrada.
    $mes_raw = isset($_POST['mes']) ? sanitize_text_field(wp_unslash($_POST['mes'])) : '';
    $interes_raw = isset($_POST['interes']) ? sanitize_text_field(wp_unslash($_POST['interes'])) : '';

    $mes = absint($mes_raw);
    $interes = floatval($interes_raw);

    if ($mes > 0) {
        $wpdb->insert(
            $table_name,
            array(
                'meses' => $mes,
                'interes' => $interes
            ),
            array('%d', '%f') // Formato de datos para seguridad
        );
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Cuota agregada correctamente.', 'mz-calculate-fees') . '</p></div>';
    } else {
        echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__('Error: Los meses deben ser mayor a 0.', 'mz-calculate-fees') . '</p></div>';
    }
}

// --- Lógica de Eliminado ---
if (isset($_POST['plst_delete_id'])) {
    // Sanitizar y validar ID recibido.
    $id_to_delete_raw = isset($_POST['plst_delete_id']) ? sanitize_text_field(wp_unslash($_POST['plst_delete_id'])) : '';
    $id_to_delete = absint($id_to_delete_raw);

    if ($id_to_delete) {
        // Verificar CSRF (Nonce) con el ID ya validado.
        check_admin_referer('plst_delete_fee_action_' . $id_to_delete);

        $wpdb->delete($table_name, array('id' => $id_to_delete), array('%d'));

        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Cuota eliminada.', 'mz-calculate-fees') . '</p></div>';
    }
}

// Obtener datos para la tabla
// phpcs:ignore WordPress.DB.DirectDatabaseQuery
$query = $wpdb->get_results("SELECT * FROM $table_name ORDER BY meses ASC");
// phpcs:enable
?>

<div class="wrap plst-calc-admin-settings">
    <div class="plst-calc-header">
        <div>
            <h1><?php esc_html_e('Installment Months & Interest Settings', 'mz-calculate-fees'); ?></h1>
            <p class="plst-calc-subtitle">
                <?php esc_html_e('Configure how many months and what interest rate will be used to calculate the installment amount on product pages.', 'mz-calculate-fees'); ?>
            </p>
        </div>
        <div class="plst-calc-badge">
            <span class="plst-calc-badge-label">
                <?php esc_html_e('WooCommerce Installments', 'mz-calculate-fees'); ?>
            </span>
        </div>
    </div>

    <div class="plst-calc-grid">
        <!-- Card: Add new installment -->
        <div class="plst-calc-card">
            <div class="plst-calc-card-header">
                <div>
                    <h2><?php esc_html_e('Add New Installment', 'mz-calculate-fees'); ?></h2>
                    <p><?php esc_html_e('Define the number of months and interest percentage for a new installment option.', 'mz-calculate-fees'); ?>
                    </p>
                </div>
            </div>

            <form action="" method="POST" id="plst-add-form" class="plst-calc-form">
                <?php wp_nonce_field('plst_add_fee_action', 'plst_add_fee_nonce'); ?>

                <div class="plst-calc-form-row">
                    <label for="mes">
                        <?php esc_html_e('Months', 'mz-calculate-fees'); ?>
                        <span class="plst-calc-required">*</span>
                    </label>
                    <input type="number" id="mes" name="mes" required min="1" step="1" class="plst-calc-input"
                        placeholder="<?php esc_attr_e('e.g. 6', 'mz-calculate-fees'); ?>" />
                    <p class="plst-calc-help">
                        <?php esc_html_e('Total number of months the order will be split into.', 'mz-calculate-fees'); ?>
                    </p>
                </div>

                <div class="plst-calc-form-row">
                    <label for="interes">
                        <?php esc_html_e('Interest (%)', 'mz-calculate-fees'); ?>
                        <span class="plst-calc-required">*</span>
                    </label>
                    <input type="number" id="interes" name="interes" required step="0.01" class="plst-calc-input"
                        placeholder="<?php esc_attr_e('e.g. 12.5', 'mz-calculate-fees'); ?>" />
                    <p class="plst-calc-help">
                        <?php esc_html_e('Annual or total interest rate applied to this installment option.', 'mz-calculate-fees'); ?>
                    </p>
                </div>

                <div class="plst-calc-form-actions">
                    <?php submit_button(__('Add installment', 'mz-calculate-fees'), 'primary', 'plst_submit_add', false); ?>
                </div>
            </form>
        </div>

        <!-- Card: Existing installments -->
        <div class="plst-calc-card">
            <div class="plst-calc-card-header">
                <div>
                    <h2><?php esc_html_e('Existing Installments', 'mz-calculate-fees'); ?></h2>
                    <p><?php esc_html_e('Manage all available installment options used on WooCommerce product pages.', 'mz-calculate-fees'); ?>
                    </p>
                </div>
            </div>

            <div class="plst-calc-table-wrapper">
                <table class="plst-calc-table">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Months', 'mz-calculate-fees'); ?></th>
                            <th><?php esc_html_e('Interest (%)', 'mz-calculate-fees'); ?></th>
                            <th class="plst-calc-col-actions"><?php esc_html_e('Actions', 'mz-calculate-fees'); ?>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($query): ?>
                            <?php foreach ($query as $row): ?>
                                <tr>
                                    <td>
                                        <strong><?php echo esc_html($row->meses); ?></strong>
                                    </td>
                                    <td>
                                        <?php echo esc_html($row->interes); ?>%
                                    </td>
                                    <td class="plst-calc-table-actions">
                                        <form method="POST" action="" style="display:inline;">
                                            <?php wp_nonce_field('plst_delete_fee_action_' . $row->id); ?>
                                            <input type="hidden" value="<?php echo esc_attr($row->id); ?>"
                                                name="plst_delete_id" />
                                            <button type="submit" class="button plst-calc-button-danger"
                                                onclick="return confirm('<?php esc_attr_e('Are you sure you want to delete this installment?', 'mz-calculate-fees'); ?>');">
                                                <?php esc_html_e('Delete', 'mz-calculate-fees'); ?>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="3" class="plst-calc-empty">
                                    <?php esc_html_e('No installments configured yet. Add your first installment using the form on the left.', 'mz-calculate-fees'); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>