<?php
/*
Plugin Name: MyStoreGuardian Connector
Description: Connect your store to start monitoring for broken buttons and checkout glitches.
Version: 1.0.5
Author: MyStoreGuardian
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

// Prevent direct access to this file
if (!defined('ABSPATH')) {
    exit;
}

// 1. Add the Widget to the WordPress Dashboard
add_action('wp_dashboard_setup', 'msg_add_dashboard_widget');

function msg_add_dashboard_widget() {
    // This creates a box on the main WP Admin Dashboard
    wp_add_dashboard_widget(
        'msg_connect_widget',          // Widget ID
        'MyStoreGuardian Status',      // Title
        'msg_render_connect_widget'    // Callback function
    );
}

// 2. Render the Dashboard Widget Content
function msg_render_connect_widget() {
    
    // --- CONFIGURATION ---
    $app_url = 'https://mystoreguardian.com';
    $logo_url = plugins_url( 'assets/logo_1200px.png', __FILE__ );
    // ---------------------

    // Get current User and Store info
    $current_user = wp_get_current_user();
    $store_url = get_site_url();
    $email = $current_user->user_email;

    // Securely pass the email and URL to your smart entry route
    $smart_entry_url = $app_url . '/auth/wordpress-entry?' . http_build_query(array(
        'store' => $store_url,
        'email' => $email
    ));

    // --- DASHBOARD WIDGET HTML ---
    ?>
    <div style="text-align: center; padding: 15px 5px;">
        
        <img src="<?php echo esc_url($logo_url); ?>" 
             alt="MyStoreGuardian Logo" 
             style="max-width: 80px; height: auto; margin-bottom: 15px;">

        <h3 style="margin: 0 0 10px 0; font-size: 16px; color: #d63638;">
            Stop losing sales to technical glitches.
        </h3>

        <p style="font-size: 13px; line-height: 1.5; margin-bottom: 15px; color: #3c434a;">
            Ensure your WooCommerce store is always ready to sell. We test your store exactly like a real customer would. 
            Our A.I. powered tool checks your product page inventory, tests your buttons, and simulates a checkout flow. 
            If something breaks, you will be notified instantly.
        </p>

        <a href="<?php echo esc_url($smart_entry_url); ?>" target="_blank" class="button button-primary button-hero" style="width: 100%; text-align: center; margin-bottom: 10px;">
            🚀 Start for free
        </a>

        <p style="font-size: 12px; color: #666; margin: 5px 0 0 0;">
            Upgrade as you grow.<br>
            <strong>14-Day Free Trial</strong> available on the Starter plan.
        </p>
    </div>
    <?php
}

// Inject custom CSS to make the menu icon blue
add_action('admin_head', 'msg_custom_menu_icon_color');

function msg_custom_menu_icon_color() {
    echo '<style>
        /* 1. Normal state: Blue icon */
        #toplevel_page_mystoreguardian-settings .wp-menu-image::before {
            color: #2563eb !important; 
        }
        
        /* 2. Hover & Active state: White icon on the blue background */
        #toplevel_page_mystoreguardian-settings:hover .wp-menu-image::before,
        #toplevel_page_mystoreguardian-settings.current .wp-menu-image::before,
        #toplevel_page_mystoreguardian-settings.wp-has-current-submenu .wp-menu-image::before {
            color: #ffffff !important; 
        }
    </style>';
}

// 3. Add the Left Menu Item
add_action('admin_menu', 'msg_add_admin_menu');

function msg_add_admin_menu() {
    add_menu_page(
        'MyStoreGuardian',            // Page title
        'MyStoreGuardian',            // Menu title
        'manage_options',             // Capability required (Admins only)
        'mystoreguardian-settings',   // Menu slug
        'msg_render_admin_page',      // Callback function to render the page
        'dashicons-store',            // Icon (Looks like a little shop)
        98                            // Position in the menu
    );
}

// 4. Render the Full Admin Page
function msg_render_admin_page() {
    $app_url = 'https://mystoreguardian.com';
    $logo_url = plugins_url( 'assets/logo_1200px.png', __FILE__ );

    $current_user = wp_get_current_user();
    $store_url = get_site_url();
    $email = $current_user->user_email;

    // Securely pass the email and URL to your smart entry route
    $smart_entry_url = $app_url . '/auth/wordpress-entry?' . http_build_query(array(
        'store' => $store_url,
        'email' => $email
    ));

    ?>
    <div class="wrap" style="max-width: 600px; margin: 40px auto; background: #fff; padding: 40px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); text-align: center;">
        
        <img src="<?php echo esc_url($logo_url); ?>" alt="MyStoreGuardian Logo" style="max-width: 120px; height: auto; margin-bottom: 20px;">
        
        <h1 style="font-size: 24px; color: #d63638; margin-bottom: 15px;">
            Stop losing sales to technical glitches.
        </h1>
        
        <p style="font-size: 15px; line-height: 1.6; color: #3c434a; margin-bottom: 30px;">
            Ensure your WooCommerce store is always ready to sell. We test your store exactly like a real customer would. 
            Our A.I. powered tool checks your product page inventory, tests your buttons, and simulates a checkout flow. 
            If something breaks, you will be notified instantly.
        </p>
        
        <a href="<?php echo esc_url($smart_entry_url); ?>" target="_blank" class="button button-primary button-hero" style="font-size: 16px; padding: 10px 30px; height: auto;">
            🚀 Start for free / Go to Dashboard
        </a>

        <p style="font-size: 13px; color: #666; margin-top: 20px;">
            Upgrade as you grow.<br>
            <strong>14-Day Free Trial</strong> available on the Starter plan.
        </p>

    </div>
    <?php
}