/**
 * Dashboard Widget JavaScript
 *
 * @package MUSTWP
 */

(function() {
    'use strict';
    
    const widget = document.querySelector('.mustwp-dashboard-widget');
    if (!widget) {
        return;
    }
    
    // Get all device accordions
    const deviceAccordions = widget.querySelectorAll('.mustwp-device-accordion');
    
    if (deviceAccordions.length === 0) {
        return;
    }
    
    // Make accordions mutually exclusive
    deviceAccordions.forEach(accordion => {
        accordion.addEventListener('toggle', function() {
            // If this accordion is opening, close all others
            if (this.open) {
                deviceAccordions.forEach(otherAccordion => {
                    if (otherAccordion !== this && otherAccordion.open) {
                        otherAccordion.open = false;
                    }
                });
            }
        });
    });
})();
