#!/usr/bin/env node

/**
 * Simple build script for WPO
 * Copies source files to assets directory
 */

const fs = require('fs');
const path = require('path');

function copyFile(src, dest) {
    const destDir = path.dirname(dest);
    
    // Create destination directory if it doesn't exist
    if (!fs.existsSync(destDir)) {
        fs.mkdirSync(destDir, { recursive: true });
    }
    
    // Copy file
    fs.copyFileSync(src, dest);
    console.log(`Copied: ${src} -> ${dest}`);
}

function build() {
    console.log('Building WPO assets...');
    
    // Copy JavaScript files
    copyFile('src/js/editor.js', 'build/js/editor.js');
    copyFile('src/js/admin.js', 'build/js/admin.js');
    
    // Copy CSS files
    copyFile('src/css/admin.css', 'build/css/admin.css');
    
    console.log('Build complete!');
}

// Run build
build();
