<?php
declare(strict_types=1);
namespace Mop_Ai_Indexer\Includes\Logic;

/**
 * Contains and provides allowed HTML tags and attributes for wp_kses()
 *
 * @link       https://ministryofplugins.com/anjana-hemachandra
 * @since      1.0.0
 *
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/includes/logic
 */

/**
 * If this file is called directly, then exit.
 */
if (! defined('ABSPATH')) exit;

/**
 * Contains and provides allowed HTML tags and attributes for wp_kses().
 *
 * This class is to contain and provide allowed HTML tags and attributes for wp_kses().
 *
 * @since      1.0.0
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/includes/logic
 * @author     Anjana Hemachandra
 */
class Mop_Ai_Indexer_Allowed_Html {

	/**
	 * Contains allowed HTML tags and attributes for wp_kses().
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      array    $allowed_html    Contains allowed HTML tags and attributes.
	 */
	private static array $allowed_html = array(
			'div' => array(
			'class' => true,
			'id' => true,
			'style' => true,
		),
			'h1' => array(
			'class' => true,
		),
			'h2' => array(
			'id' => true,
		),
			'h3' => array(
			'id' => true,
			'class' => true,
		),
			'p' => array(
			'class' => true,
			'style' => true,
		),
			'strong' => array(),
			'br' => array(),
			'a' => array(
			'href' => true,
			'class' => true,
			'target' => true,
		),
			'button' => array(
			'type' => true,
			'class' => true,
			'aria-hidden' => true,
			'id' => true,
			'role' => true,
			'draggable' => true,
		),
			'span' => array(
			'class' => true,
			'aria-hidden' => true,
			'id' => true,
			'style' => true,
		),
			'img' => array(
			'src' => true,
			'alt' => true,
			'class' => true,
			'id' => true,
			'draggable' => true,
			'role' => true,
		),
			'table' => array(
			'class' => true,
		),
			'thead' => array(),
			'tfoot' => array(),
			'tbody' => array(
			'id' => true,
		),
			'tr' => array(
			'class' => true,
			'hidden' => true,
		),
			'th' => array(
			'scope' => true,
			'id' => true,
			'class' => true,
		),
			'td' => array(
			'class' => true,
			'data-colname' => true,
			'colspan' => true,
		),
			'code' => array(),
			'b' => array(),
			'iframe' => array(
			'src' => true,
			'title' => true,
			'frameborder' => true,
			'allow' => true,
			'referrerpolicy' => true,
			'allowfullscreen' => true,
			'class' => true,
		),
			'ul' => array(
			'style' => true,
		),
			'li' => array(),
			'input' => array(
			'type' => true,
			'name' => true,
			'value' => true,
			'id' => true,
			'class' => true,
			'checked' => true,
			'hidden' => true,
		),
			'form' => array(
			'action' => true,
			'method' => true,
		),
			'fieldset' => array(),
			'label' => array(
			'for' => true,
		),
			'hr' => array(
			'class' => true,
		),
			'html' => array(),
			'head' => array(),
			'body' => array(),
			'nav' => array(),
			'article' => array(),
			'section' => array(),
			'textarea' => array(
			'name' => true,
			'rows' => true,
			'cols' => true,
			'class' => true,
			'id' => true,
			'disabled' => true,
			'readonly' => true,
			'maxlength' => true,
		),
			'select' => array(
			'id' => true,
			'name' => true,
			'class' => true,
		),
			'option' => array(
			'value' => true,
			'disabled' => true,
			'selected' => true,
		),
	);

	/**
	 * Provides allowed HTML tags and attributes for wp_kses() functions of the whole plugin.
	 *
	 * @since     1.0.0
	 * @return    array    An array of allowed HTML tags and attributes for wp_kses().
	 */
	public static function get_allowed_html(): array {

		return apply_filters('mop_ai_indexer_allowed_html', self::$allowed_html);
	}
}
