<?php
declare(strict_types=1);
namespace Mop_Ai_Indexer\Includes;

/**
 * Fires during plugin deactivation
 *
 * @link       https://ministryofplugins.com/anjana-hemachandra
 * @since      1.0.0
 *
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/includes
 */

/**
 * If this file is called directly, then exit.
 */
if (! defined('ABSPATH')) exit;

/**
 * Import classes from sub-namespaces.
 */
use Mop_Ai_Indexer\Includes\Logic\{Mop_Ai_Indexer_Cron_Manager};

/**
 * Fires during plugin deactivation.
 *
 * This class is to execute all necessary actions on plugin deactivation.
 *
 * @since      1.0.0
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/includes
 * @author     Anjana Hemachandra
 */
class Mop_Ai_Indexer_Deactivator {

	/**
	 * Executes all necessary actions on plugin deactivation.
	 *
	 * @since    1.0.0
	 * @see      Mop_Ai_Indexer_Cron_Manager
	 */
	public static function deactivate(): void {

		/**
		 * If the current user is not allowed to activate plugins, then die.
		 */
		if (! current_user_can('activate_plugins')) wp_die('Something is not right.');

		Mop_Ai_Indexer_Cron_Manager::unschedule_all_events();

		/**
		 * All function calls to be fired on plugin deactivation.
		 */
		self::flush_all_rewrite_rules();
	}

	/**
	 * Flushes all rewrite rules by deleting rewrite_rules options.
	 * 
	 * The inbuilt flush_rewrite_rules() function is not used
	 * because it has some technical problems when executing
	 * plugin activation and deactivation.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private static function flush_all_rewrite_rules(): void {

		delete_option('rewrite_rules');
	}
}
