<?php
declare(strict_types=1);
namespace Mop_Ai_Indexer\Admin\Partials;

/**
 * Provides the markup to index settings admin-interface
 *
 * This file is used to markup the index settings admin-interface.
 *
 * @link       https://ministryofplugins.com/anjana-hemachandra
 * @since      1.0.0
 *
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin/partials
 */

/**
 * If this file is called directly, then exit.
 */
if (! defined('ABSPATH')) exit;

?>

<div class="wrap">

	<h1><?php echo esc_html(get_admin_page_title()); ?></h1>

	<?php if (! ($notice_output === '')) echo wp_kses($notice_output, $allowed_html); ?>

	<div>
		<form action="<?php echo esc_url(admin_url('admin.php?page=mop-ai-indexer-index-settings&noheader=true')); ?>" method="post">
			<h2 class="title"><?php esc_html_e('General Settings', 'mop-ai-indexer'); ?></h2>
			<table class="form-table">
				<tbody>
					<tr>
						<th scope="row"><?php esc_html_e('Index File Name and Format', 'mop-ai-indexer'); ?></th>
						<td>
							<fieldset class="iset-file-name-format-options" aria-describedby="iset-file-name-format-desc">
								<label class="iset-file-name-format-option" for="iset-fnf-llms-txt">
									<input type="radio" name="iset_file_name_format" id="iset-fnf-llms-txt" value="llms.txt" <?php echo (isset($iset_file_name_format) && $iset_file_name_format === 'llms.txt') ? 'checked' : ''; ?>>
									<?php echo esc_html('llms.txt'); ?>
								</label>
								<br>
								<label class="iset-file-name-format-option" for="iset-fnf-llms-full-txt">
									<input type="radio" name="iset_file_name_format" id="iset-fnf-llms-full-txt" value="llms-full.txt" <?php echo (isset($iset_file_name_format) && $iset_file_name_format === 'llms-full.txt') ? 'checked' : ''; ?>>
									<?php echo esc_html('llms-full.txt'); ?>
								</label>
								<p id="iset-file-name-format-desc" class="description"><?php esc_html_e('Select the file name and format for the index file that will be served to AI Bots.', 'mop-ai-indexer'); ?></p>
								<p class="description"><?php esc_html_e('Note: Changing this setting deletes the current index file. Regenerate it via the Index Manager page.', 'mop-ai-indexer'); ?></p>
							</fieldset>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php esc_html_e('Update Frequency', 'mop-ai-indexer'); ?></th>
						<td>
							<fieldset class="iset-update-frequency-options" aria-describedby="iset-update-frequency-desc">
								<select name="iset_update_frequency" id="iset-update-frequency" class="iset-update-frequency-select">
									<option value="manual" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'manual') ? 'selected' : ''; ?>><?php esc_html_e('Manual Update', 'mop-ai-indexer'); ?></option>
									<option value="twice-a-day" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'twice-a-day') ? 'selected' : ''; ?>><?php esc_html_e('Twice a day', 'mop-ai-indexer'); ?></option>
									<option value="once-a-day" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'once-a-day') ? 'selected' : ''; ?>><?php esc_html_e('Once a day', 'mop-ai-indexer'); ?></option>
									<option value="every-2-days" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'every-2-days') ? 'selected' : ''; ?>><?php esc_html_e('Every 2 days', 'mop-ai-indexer'); ?></option>
									<option value="every-3-days" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'every-3-days') ? 'selected' : ''; ?>><?php esc_html_e('Every 3 days', 'mop-ai-indexer'); ?></option>
									<option value="every-4-days" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'every-4-days') ? 'selected' : ''; ?>><?php esc_html_e('Every 4 days', 'mop-ai-indexer'); ?></option>
									<option value="every-5-days" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'every-5-days') ? 'selected' : ''; ?>><?php esc_html_e('Every 5 days', 'mop-ai-indexer'); ?></option>
									<option value="every-6-days" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'every-6-days') ? 'selected' : ''; ?>><?php esc_html_e('Every 6 days', 'mop-ai-indexer'); ?></option>
									<option value="once-a-week" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'once-a-week') ? 'selected' : ''; ?>><?php esc_html_e('Once a week', 'mop-ai-indexer'); ?></option>
									<option value="every-2-weeks" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'every-2-weeks') ? 'selected' : ''; ?>><?php esc_html_e('Every 2 weeks', 'mop-ai-indexer'); ?></option>
									<option value="every-3-weeks" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'every-3-weeks') ? 'selected' : ''; ?>><?php esc_html_e('Every 3 weeks', 'mop-ai-indexer'); ?></option>
									<option value="every-4-weeks" <?php echo (isset($iset_update_frequency) && $iset_update_frequency === 'every-4-weeks') ? 'selected' : ''; ?>><?php esc_html_e('Every 4 weeks', 'mop-ai-indexer'); ?></option>
								</select>
								<p id="iset-update-frequency-desc" class="description"><?php esc_html_e('Select how often the index file should be updated.', 'mop-ai-indexer'); ?></p>
							</fieldset>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php esc_html_e('Enable MOP AI Indexer Post Meta Box', 'mop-ai-indexer'); ?></th>
						<td>
							<fieldset class="iset-enable-mop-ai-indexer-post-meta-box-options" aria-describedby="iset-enable-mop-ai-indexer-post-meta-box-desc">
								<input type="checkbox" name="iset_enable_mop_ai_indexer_post_meta_box" id="iset-enable-mop-ai-indexer-post-meta-box" value="enable-meta-box" <?php echo (isset($iset_enable_mop_ai_indexer_post_meta_box) && $iset_enable_mop_ai_indexer_post_meta_box === 'enable-meta-box') ? 'checked' : ''; ?>>
								<label class="iset-enable-mop-ai-indexer-post-meta-box-option" for="iset-enable-mop-ai-indexer-post-meta-box"><?php esc_html_e('Add the MOP AI Indexer meta box to each post for every post type selected under Index Configurations.', 'mop-ai-indexer'); ?></label>
								<p id="iset-enable-mop-ai-indexer-post-meta-box-desc" class="description"><?php esc_html_e('Use this meta box to prevent specific posts from being included in the index file.', 'mop-ai-indexer'); ?></p>
							</fieldset>
						</td>
					</tr>

					<tr>
						<th scope="row"><?php esc_html_e('Respect SEO Configurations', 'mop-ai-indexer'); ?></th>
						<td>
							<fieldset class="iset-respect-seo-config-options" aria-describedby="iset-respect-seo-config-desc">
								<input type="checkbox" name="iset_respect_seo_config" id="iset-respect-seo-config" value="respect-seo" <?php echo (isset($iset_respect_seo_config) && $iset_respect_seo_config === 'respect-seo') ? 'checked' : ''; ?>>
								<label class="iset-respect-seo-config-option" for="iset-respect-seo-config"><?php esc_html_e('Exclude pages blocked by robots.txt or tagged with noindex.', 'mop-ai-indexer'); ?></label>
								<p id="iset-respect-seo-config-desc" class="description"><?php esc_html_e('When enabled, pages blocked in robots.txt or marked noindex (including via Yoast SEO, Rank Math, SEOPress, or All in One SEO) are excluded from generated index file.', 'mop-ai-indexer'); ?></p>
							</fieldset>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php esc_html_e('Strict indexability check (HTTP)', 'mop-ai-indexer'); ?></th>
						<td>
							<fieldset class="iset-strict-indexability-check-options" aria-describedby="iset-strict-indexability-check-desc">
								<input type="checkbox" name="iset_strict_indexability_check" id="iset-strict-indexability-check" value="strict-check" <?php echo (isset($iset_strict_indexability_check) && $iset_strict_indexability_check === 'strict-check') ? 'checked' : ''; ?>>
								<label class="iset-strict-indexability-check-option" for="iset-strict-indexability-check"><?php esc_html_e('Also exclude pages that are marked noindex/nofollow via HTTP headers or robots meta tags.', 'mop-ai-indexer'); ?></label>
								<p id="iset-strict-indexability-check-desc" class="description"><?php esc_html_e('When enabled, MOP AI Indexer will fetch each URL (HEAD/GET) to detect X-Robots-Tag and <meta name="robots"> directives. This improves accuracy but can slow down generation on large sites.', 'mop-ai-indexer'); ?></p>
							</fieldset>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php esc_html_e('Purge caches after generation/deletion', 'mop-ai-indexer'); ?></th>
						<td>
							<fieldset class="iset-purge-caches-after-generation-deletion-options" aria-describedby="iset-purge-caches-after-generation-deletion-desc">
								<input type="checkbox" name="iset_purge_caches_after_generation_deletion" id="iset-purge-caches-after-generation-deletion" value="purge-caches" <?php echo (isset($iset_purge_caches_after_generation_deletion) && $iset_purge_caches_after_generation_deletion === 'purge-caches') ? 'checked' : ''; ?>>
								<label class="iset-purge-caches-after-generation-deletion-option" for="iset-purge-caches-after-generation-deletion"><?php esc_html_e('Purge caches after a successful generation or deletion.', 'mop-ai-indexer'); ?></label>
								<p id="iset-purge-caches-after-generation-deletion-desc" class="description"><?php esc_html_e('When enabled, MOP AI Indexer will attempt to purge common WordPress caches after the index file is successfully generated or deleted. If the website is behind a CDN like Cloudflare, you may have to purge those caches manually.', 'mop-ai-indexer'); ?></p>
							</fieldset>
						</td>
					</tr>

				</tbody>
			</table>

			<h2 class="title"><?php esc_html_e('Default Settings', 'mop-ai-indexer'); ?></h2>
			<table class="form-table">
				<tbody>
					<tr>
						<th scope="row"><?php esc_html_e('Back to Default Settings', 'mop-ai-indexer'); ?></th>
						<td>
							<fieldset>
								<input type="checkbox" name="iset_back_to_default" id="iset-back-to-default" value="true">
								<label for="iset-back-to-default">&#9888; <?php esc_html_e('Reverts all current Index Settings back to their defaults.', 'mop-ai-indexer'); ?></label>
								<p><?php esc_html_e('Note: Please check this checkbox and click the Save Index Settings button to reset the Index Settings to their defaults.', 'mop-ai-indexer'); ?></p>
							</fieldset>
						</td>
					</tr>
				</tbody>
			</table>

			<p class="submit">
				<input type="submit" name="iset_save" class="button button-primary button-large" value="<?php esc_attr_e('Save Index Settings', 'mop-ai-indexer'); ?>">
				<?php wp_nonce_field('mop_ai_indexer_save_iset_action', 'mop_ai_indexer_save_iset_nonce_field', false); ?>
			</p>	
		</form>
	</div>

</div>
