<?php
declare(strict_types=1);
namespace Mop_Ai_Indexer\Admin\Partials;

/**
 * Provides the markup to index manager admin-interface
 *
 * This file is used to markup the index manager admin-interface.
 *
 * @link       https://ministryofplugins.com/anjana-hemachandra
 * @since      1.0.0
 *
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin/partials
 */

/**
 * If this file is called directly, then exit.
 */
if (! defined('ABSPATH')) exit;

?>

<div class="wrap">

	<h1><?php echo esc_html(get_admin_page_title()); ?></h1>

	<?php if (! ($notice_output === '')) echo wp_kses($notice_output, $allowed_html); ?>

	<?php if (! ($discourage_search_warn_output === '')) echo wp_kses($discourage_search_warn_output, $allowed_html); ?>

	<div class="mop-ai-indexer-toolbar">
		<button type="button" id="mop-ai-indexer-generate-file" class="page-title-action mop-ai-indexer-toolbar-btn"><?php esc_html_e('Generate Index File', 'mop-ai-indexer'); ?></button>
		<button type="button" id="mop-ai-indexer-delete-file" class="page-title-action mop-ai-indexer-toolbar-btn"><?php esc_html_e('Delete Index File', 'mop-ai-indexer'); ?></button>
		<form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="mop-ai-indexer-toolbar-form">
			<input type="hidden" name="action" value="mop_ai_indexer_clear_caches" />
			<?php wp_nonce_field('mop_ai_indexer_clear_caches_action', 'mop_ai_indexer_clear_caches_nonce_field'); ?>
			<button type="submit" class="page-title-action mop-ai-indexer-toolbar-btn"><?php esc_html_e('Clear Caches', 'mop-ai-indexer'); ?></button>
		</form>
		<span id="mop-ai-indexer-file-status" class="mop-ai-indexer-file-status">
			<?php echo (isset($file_status_html)) ? wp_kses_post($file_status_html) : ''; ?>
		</span>
	</div>

	<div id="mop-ai-indexer-progress-ui" class="mop-ai-indexer-progress-ui" style="display:none;">
		<div class="mop-ai-indexer-progress-bar-wrap" role="progressbar" aria-valuemin="0" aria-valuemax="100">
			<div id="mop-ai-indexer-progress-bar" class="mop-ai-indexer-progress-bar" style="width:0%;"></div>
		</div>
		<div class="mop-ai-indexer-progress-meta">
			<span id="mop-ai-indexer-progress-percent">0%</span>
			<span id="mop-ai-indexer-progress-message"></span>
		</div>
	</div>

	<h2 class="title"><?php esc_html_e('Index Generation Logs', 'mop-ai-indexer'); ?></h2>

	<div class="mop-ai-indexer-genlog-wrapper">
		<div class="mop-ai-indexer-genlog-box">
			<h3 id="mop-ai-indexer-genlog-title"><?php echo esc_html($generation_logs_title !== '' ? $generation_logs_title : esc_html__('Index File Generation: Manual Generation (AJAX)', 'mop-ai-indexer')); ?></h3>
			<div id="mop-ai-indexer-genlog-lines" class="mop-ai-indexer-genlog-lines">
				<?php if (! empty($generation_logs_lines)) { ?>
					<?php foreach ($generation_logs_lines as $mop_ai_indexer_genlog_line) { ?>
						<div class="mop-ai-indexer-genlog-line"><?php echo esc_html((string)$mop_ai_indexer_genlog_line); ?></div>
					<?php } ?>
				<?php }else{ ?>
					<div class="mop-ai-indexer-genlog-line mop-ai-indexer-genlog-empty"><?php esc_html_e('No generation logs available yet.', 'mop-ai-indexer'); ?></div>
				<?php } ?>
			</div>
		</div>
	</div>


	<h2 class="title"><?php esc_html_e('Index Configurations', 'mop-ai-indexer'); ?></h2>

	<div>
		<form action="<?php echo esc_url(admin_url('admin.php?page=mop-ai-indexer&noheader=true')); ?>" method="post">
			<div class="mop-ai-indexer-config-card-grid">

				<?php foreach ($post_types_to_index as $mop_ai_indexer_ic_slug => $mop_ai_indexer_ic_label): ?>

					<?php
					if (isset($mop_ai_indexer_config['post_type_config'][$mop_ai_indexer_ic_slug])) {
					    $mop_ai_indexer_ic_post_config = $mop_ai_indexer_config['post_type_config'][$mop_ai_indexer_ic_slug];
					}
					?>

					<div class="mop-ai-indexer-config-card">
						<p style = "font-size: 16px; color: #861518;"><strong><?php esc_html_e('Post Type:', 'mop-ai-indexer'); ?> <?php echo (isset($mop_ai_indexer_ic_label)) ? esc_html($mop_ai_indexer_ic_label) : ''; ?></strong></p>
						<p><strong><?php esc_html_e('Post Type Slug:', 'mop-ai-indexer'); ?></strong> <?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_html($mop_ai_indexer_ic_slug) : ''; ?></p>
						<p>
							<label>
								<input type="checkbox" name="ic[<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>][include_in_mop_ai_indexer]" value="1" <?php echo (isset($mop_ai_indexer_ic_post_config['include_in_mop_ai_indexer']) && $mop_ai_indexer_ic_post_config['include_in_mop_ai_indexer'] === '1') ? 'checked' : ''; ?>>
								<?php esc_html_e('Include in index file', 'mop-ai-indexer'); ?>
							</label>
						</p>
						<p>
							<label for="ic-order-prio-<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>">
								<strong><?php esc_html_e('Order priority in index file:', 'mop-ai-indexer'); ?></strong>
							</label>
							<br>
							<input id="ic-order-prio-<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>" type="number" min="0" step="1" name="ic[<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>][order_priority_in_index]" value="<?php echo (isset($mop_ai_indexer_ic_post_config['order_priority_in_index'])) ? esc_attr($mop_ai_indexer_ic_post_config['order_priority_in_index']) : ''; ?>">
						</p>
						<p>
							<label for="ic-num-post-<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>">
								<strong><?php esc_html_e('Number of latest posts to include:', 'mop-ai-indexer'); ?></strong>
							</label>
							<br>
							<input id="ic-num-post-<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>" type="number" min="0" step="1" name="ic[<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>][num_of_latest_posts]" value="<?php echo (isset($mop_ai_indexer_ic_post_config['num_of_latest_posts'])) ? esc_attr($mop_ai_indexer_ic_post_config['num_of_latest_posts']) : ''; ?>">
						</p>
						<p>
							<label for="ic-max-con-<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>">
								<strong><?php esc_html_e('Max content length per post (words):', 'mop-ai-indexer'); ?></strong>
							</label>
							<br>
							<input id="ic-max-con-<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>" type="number" min="0" step="1" name="ic[<?php echo esc_attr($mop_ai_indexer_ic_slug); ?>][max_content_length]" value="<?php echo (isset($mop_ai_indexer_ic_post_config['max_content_length'])) ? esc_attr($mop_ai_indexer_ic_post_config['max_content_length']) : ''; ?>">
							<br>
							<span><?php esc_html_e('0 means no post content is included.', 'mop-ai-indexer'); ?></span>
						</p>
						<p>
							<label>
								<input type="checkbox" name="ic[<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>][include_meta_info]" value="1" <?php echo (isset($mop_ai_indexer_ic_post_config['include_meta_info']) && $mop_ai_indexer_ic_post_config['include_meta_info'] === '1') ? 'checked' : ''; ?>>
								<?php esc_html_e('Include meta info (published date, author, etc.)', 'mop-ai-indexer'); ?>
							</label>
						</p>
						<p>
							<label>
								<input type="checkbox" name="ic[<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>][include_exc_meta_desc]" value="1" <?php echo (isset($mop_ai_indexer_ic_post_config['include_exc_meta_desc']) && $mop_ai_indexer_ic_post_config['include_exc_meta_desc'] === '1') ? 'checked' : ''; ?>>
								<?php esc_html_e('Include post excerpts or meta descriptions', 'mop-ai-indexer'); ?>
							</label>
						</p>
						<p>
							<label>
								<input type="checkbox" name="ic[<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>][include_taxonomies]" value="1" <?php echo (isset($mop_ai_indexer_ic_post_config['include_taxonomies']) && $mop_ai_indexer_ic_post_config['include_taxonomies'] === '1') ? 'checked' : ''; ?>>
								<?php esc_html_e('Include taxonomies (categories, tags, etc.)', 'mop-ai-indexer'); ?>
							</label>
						</p>
						<p>
							<label>
								<input type="checkbox" name="ic[<?php echo (isset($mop_ai_indexer_ic_slug)) ? esc_attr($mop_ai_indexer_ic_slug) : ''; ?>][include_custom_fields]" value="1" <?php echo (isset($mop_ai_indexer_ic_post_config['include_custom_fields']) && $mop_ai_indexer_ic_post_config['include_custom_fields'] === '1') ? 'checked' : ''; ?>>
								<?php esc_html_e('Include custom fields', 'mop-ai-indexer'); ?>
							</label>
						</p>

					</div>

				<?php endforeach; ?>

			</div>

			<h2 class="title"><?php esc_html_e('Default Configurations', 'mop-ai-indexer'); ?></h2>
			<table class="form-table">
				<tbody>
					<tr>
						<th scope="row"><?php esc_html_e('Back to Default Configurations', 'mop-ai-indexer'); ?></th>
						<td>
							<fieldset>
								<input type="checkbox" name="ic_back_to_default" id="ic-back-to-default" value="true">
								<label for="ic-back-to-default">&#9888; <?php esc_html_e('Reverts all current Index Configurations back to their defaults.', 'mop-ai-indexer'); ?></label>
								<p><?php esc_html_e('Note: Please check this checkbox and click the Save Configurations button to reset the Index Configurations to their defaults.', 'mop-ai-indexer'); ?></p>
							</fieldset>
						</td>
					</tr>
				</tbody>
			</table>

			<p class="submit">
				<input type="submit" name="ic_save" class="button button-primary button-large" value="<?php esc_attr_e('Save Configurations', 'mop-ai-indexer'); ?>">
				<?php wp_nonce_field('mop_ai_indexer_save_ic_action', 'mop_ai_indexer_save_ic_nonce_field', false); ?>
			</p>
		</form>
	</div>
</div>
