<?php
declare(strict_types=1);
namespace Mop_Ai_Indexer\Admin\Partials;

/**
 * Provides the markup to concept and help admin-interface
 *
 * This file is used to markup the concept and help admin-interface.
 *
 * @link       https://ministryofplugins.com/anjana-hemachandra
 * @since      1.0.3
 *
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin/partials
 */

/**
 * If this file is called directly, then exit.
 */
if (! defined('ABSPATH')) exit;

?>

<div class="wrap">

	<h1><?php echo esc_html(get_admin_page_title()); ?></h1>

	<div class="mop-ai-indexer-tabs">
		<input id="mop-ai-indexer-tab-1" type="radio" name="mop_ai_indexer_tabs" checked>
		<label for="mop-ai-indexer-tab-1"><?php esc_html_e('Concept', 'mop-ai-indexer'); ?></label>

		<input id="mop-ai-indexer-tab-2" type="radio" name="mop_ai_indexer_tabs">
		<label for="mop-ai-indexer-tab-2"><?php esc_html_e('Coming Soon', 'mop-ai-indexer'); ?></label>

		<input id="mop-ai-indexer-tab-3" type="radio" name="mop_ai_indexer_tabs">
		<label for="mop-ai-indexer-tab-3"><?php esc_html_e('Help Resources', 'mop-ai-indexer'); ?></label>

		<input id="mop-ai-indexer-tab-4" type="radio" name="mop_ai_indexer_tabs">
		<label for="mop-ai-indexer-tab-4"><?php esc_html_e('Hooks & Constants', 'mop-ai-indexer'); ?></label>

		<div id="mop-ai-indexer-tab-content-1" class="mop-ai-indexer-tab-content mop-ai-indexer-clearfix-1800px">
			<div id="mop-ai-indexer-concept-div">
				<h2><?php esc_html_e('Philosophy', 'mop-ai-indexer'); ?></h2>
				<p><?php esc_html_e('Your WordPress site isn’t just a blog — it can be a business, a knowledge base, a product catalog, or a content engine. But most AI crawlers and LLM tools don’t experience your site like humans do. They work best when your content is presented in a clean, structured, easy-to-consume format.', 'mop-ai-indexer'); ?></p>
				<p><?php esc_html_e('With MOP AI Indexer, you can generate AI-friendly index files — like llms.txt and llms-full.txt directly from your WordPress content, and keep them updated automatically. This helps AI tools discover and understand your key pages faster, with more accurate context, and with less friction.', 'mop-ai-indexer'); ?></p>
				<p><?php esc_html_e('At Ministry of Plugins (MOP), we believe it’s our duty to develop WordPress technologies that make your content easier to discover, easier to trust, and easier to turn into real outcomes.', 'mop-ai-indexer'); ?></p>
				<h2><?php esc_html_e('Concept', 'mop-ai-indexer'); ?></h2>
				<p><?php esc_html_e('Simply install MOP AI Indexer, choose what content should be included (post types, key sections, and even per-post inclusion/exclusion), and generate your AI index file in one click — or let the plugin update it automatically on a schedule.', 'mop-ai-indexer'); ?></p>
				<p><?php esc_html_e('The important part: llms.txt / llms-full.txt are simple static text files. Once generated, your website doesn’t need to build the content dynamically every time an AI bot requests information. That means:', 'mop-ai-indexer'); ?></p>
				<ul>
					<li>&#10148; <?php esc_html_e('Requests are served fast (static file delivery is lightweight and efficient)', 'mop-ai-indexer'); ?></li>
					<li>&#10148; <?php esc_html_e('Server resources are saved (no heavy runtime queries per crawler request)', 'mop-ai-indexer'); ?></li>
					<li>&#10148; <?php esc_html_e('AI crawlers can fetch “realtime” updates quicker (because the latest content is already compiled in one place)', 'mop-ai-indexer'); ?></li>
				</ul>
				<p><?php esc_html_e('LLM crawlers love fast, clean content reception — it improves their processing time in real time. When your site is easy for them to read and retrieve quickly, your content has a better chance of being used by AI platforms, which can lead to more visibility and traffic coming from AI-based discovery tools.', 'mop-ai-indexer'); ?></p>
				<p><?php esc_html_e('In short: your WordPress site becomes AI-readable by design — controlled, efficient, and always up to date.', 'mop-ai-indexer'); ?></p>
			</div>
			<?php
			// phpcs:disable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
			// Reason: A standard method is used to display images from a subdirectory of the plugin, image URL is escaped.
			?>
			<img id="mop-ai-indexer-cover-img" src="<?php echo esc_url(MOP_AI_INDEXER_DIR_URL . 'admin/images/mop-ai-indexer-cover-image.png'); ?>" alt="<?php echo esc_attr__('MOP AI Indexer cover image', 'mop-ai-indexer'); ?>">
			<?php
			// phpcs:enable PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage
			?>
		</div>

		<div id="mop-ai-indexer-tab-content-2" class="mop-ai-indexer-tab-content">
			<h2 id="mop-ai-indexer-coming-soon-h2"><?php esc_html_e('Coming Soon', 'mop-ai-indexer'); ?></h2>
			<div id="mop-ai-indexer-coming-soon-div">
				<h3><?php esc_html_e('Bot Tracking Dashboard:', 'mop-ai-indexer'); ?></h3>
				<p><?php esc_html_e('Get clear visibility into how AI and crawler bots interact with your website. The upcoming Bot Tracking Dashboard will record requests to your AI index files (llms.txt / llms-full.txt) and other relevant endpoints, then display useful statistics such as request counts, user agents, access trends over time, and the most active bots. This helps you confirm whether AI bots are actually reading your index files and understand how frequently they visit your site.', 'mop-ai-indexer'); ?></p>

				<h3><?php esc_html_e('Bot Access Control (Allow / Block):', 'mop-ai-indexer'); ?></h3>
				<p><?php esc_html_e('Take control over which bots can access your content. This upcoming feature will let you allow or block specific AI bots and crawlers from reading your AI index files (llms.txt / llms-full.txt), with optional controls to extend restrictions to the full website when needed. It is designed to help you protect sensitive content, reduce unwanted crawling, and tailor access rules based on your SEO strategy and server performance.', 'mop-ai-indexer'); ?></p>
			</div>
		</div>

		<div id="mop-ai-indexer-tab-content-3" class="mop-ai-indexer-tab-content">
			<h2 id="mop-ai-indexer-help-res-h2"><?php esc_html_e('Help Resources', 'mop-ai-indexer'); ?></h2>
			<div id="mop-ai-indexer-help-res-div">
				<div class="mop-ai-indexer-help-div">
					<h3><?php esc_html_e('MOP AI Indexer - Quick Introduction:', 'mop-ai-indexer'); ?></h3>
					<iframe class="mop-ai-indexer-help-iframe" src="https://www.youtube.com/embed/fJNnWXsd5_M?si=0J9S7Yq5-iOZcBf1" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
					<div class="mop-ai-indexer-help-text-div">
						<p><b><?php esc_html_e('Note: Please watch the video in HD mode in full screen.', 'mop-ai-indexer'); ?></b></p>
						<p><b><?php esc_html_e('This video will show you:-', 'mop-ai-indexer'); ?></b></p>
						<p><?php esc_html_e('(1) All Features of the MOP AI Indexer Plugin.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('(2) How the plugin is structured.', 'mop-ai-indexer'); ?></p>
					</div>
				</div>
			</div>
		</div>

		<div id="mop-ai-indexer-tab-content-4" class="mop-ai-indexer-tab-content">
			<h2 id="mop-ai-indexer-hooks-and-cons-h2"><?php esc_html_e('Hooks & Constants', 'mop-ai-indexer'); ?></h2>
			<div id="mop-ai-indexer-hooks-and-cons-div">
				<div class="mop-ai-indexer-hooks-cons-div">
					<h3>MOP_AI_INDEXER_ENDPOINT_SEND_NOINDEX_HEADER</h3>
					<div class="mop-ai-indexer-hooks-cons-text-div">
						<p><?php esc_html_e('# This is a constant that can be redefined.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Redefining this constant allows you to enable or disable the X-Robots-Tag header for the AI index endpoint responses. The default value is true.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# When enabled, the endpoint sends: X-Robots-Tag: noindex, nofollow. This helps prevent search engines from indexing the AI index endpoint.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Paste the given code line into the ‘Add any custom values\' section of the wp-config.php file and change the value as desired.', 'mop-ai-indexer'); ?></p>
						<p>
							<?php esc_html_e('# Code:', 'mop-ai-indexer'); ?>
							<br>
							<code>define('MOP_AI_INDEXER_ENDPOINT_SEND_NOINDEX_HEADER', true);</code>
						</p>
					</div>
				</div>
				<div class="mop-ai-indexer-hooks-cons-div">
					<h3>MOP_AI_INDEXER_ENDPOINT_EXCLUDE_IN_SITEMAP</h3>
					<div class="mop-ai-indexer-hooks-cons-text-div">
						<p><?php esc_html_e('# This is a constant that can be redefined.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Redefining this constant allows you to control whether the AI index endpoint is excluded from WordPress core sitemaps. The default value is true.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Use this if you want to keep the endpoint out of standard SEO sitemaps while still making it available for AI crawlers.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Paste the given code line into the ‘Add any custom values\' section of the wp-config.php file and change the value as desired.', 'mop-ai-indexer'); ?></p>
						<p>
							<?php esc_html_e('# Code:', 'mop-ai-indexer'); ?>
							<br>
							<code>define('MOP_AI_INDEXER_ENDPOINT_EXCLUDE_IN_SITEMAP', true);</code>
						</p>
					</div>
				</div>
				<div class="mop-ai-indexer-hooks-cons-div">
					<h3>MOP_AI_INDEXER_ENDPOINT_HEAD_HINT_ENABLED</h3>
					<div class="mop-ai-indexer-hooks-cons-text-div">
						<p><?php esc_html_e('# This is a constant that can be redefined.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Redefining this constant allows you to enable or disable the discovery hint in the HTML <head>. The default value is true.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# When enabled, the plugin outputs a <link> hint in the site <head> to help bots discover the AI index file.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Paste the given code line into the ‘Add any custom values\' section of the wp-config.php file and change the value as desired.', 'mop-ai-indexer'); ?></p>
						<p>
							<?php esc_html_e('# Code:', 'mop-ai-indexer'); ?>
							<br>
							<code>define('MOP_AI_INDEXER_ENDPOINT_HEAD_HINT_ENABLED', true);</code>
						</p>
					</div>
				</div>
				<div class="mop-ai-indexer-hooks-cons-div">
					<h3>MOP_AI_INDEXER_ENDPOINT_ROBOTS_TXT_HINT_ENABLED</h3>
					<div class="mop-ai-indexer-hooks-cons-text-div">
						<p><?php esc_html_e('# This is a constant that can be redefined.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Redefining this constant allows you to enable or disable the discovery hint in the WordPress virtual robots.txt output. The default value is true.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# When enabled, the plugin adds a comment line to robots.txt to help bots discover the AI index file location.', 'mop-ai-indexer'); ?></p>
						<p><?php esc_html_e('# Paste the given code line into the ‘Add any custom values\' section of the wp-config.php file and change the value as desired.', 'mop-ai-indexer'); ?></p>
						<p>
							<?php esc_html_e('# Code:', 'mop-ai-indexer'); ?>
							<br>
							<code>define('MOP_AI_INDEXER_ENDPOINT_ROBOTS_TXT_HINT_ENABLED', true);</code>
						</p>
					</div>
				</div>
			</div>
		</div>
	</div>

</div>
