<?php
declare(strict_types=1);
namespace Mop_Ai_Indexer\Admin\Logic;

/**
 * Displays concept and help page of the plugin in admin area
 *
 * @link       https://ministryofplugins.com/anjana-hemachandra
 * @since      1.0.3
 *
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin/logic
 */

/**
 * If this file is called directly, then exit.
 */
if (! defined('ABSPATH')) exit;

/**
 * Import classes from sub-namespaces.
 */
use Mop_Ai_Indexer\Includes\Logic\{Mop_Ai_Indexer_Allowed_Html};

/**
 * Displays concept and help page of the plugin in admin area.
 *
 * This class is to display concept and help page of the plugin in admin area.
 *
 * @since      1.0.3
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin/logic
 * @author     Anjana Hemachandra
 */
class Mop_Ai_Indexer_Concept_And_Help_Page {

	/**
	 * Displays concept and help page of the plugin in admin area.
	 *
	 * @since    1.0.3
	 * @see      Mop_Ai_Indexer_Allowed_Html
	 */
	public function display_concept_and_help_page() {

		/**
		 * If the current user is not allowed to manage options, then die.
		 */
		if (! current_user_can('manage_options')) wp_die('Something is not right.');

		/**
		 * Retrieves $allowed_html array for wp_kses.
		 */
		$allowed_html = Mop_Ai_Indexer_Allowed_Html::get_allowed_html();

		/**
		 * Template output with output buffering.
		 */
		ob_start();
		require_once MOP_AI_INDEXER_DIR_PATH . 'admin/partials/mop-ai-indexer-concept-and-help-template.php';
		echo wp_kses(ob_get_clean(), $allowed_html);
	}
}
