<?php
declare(strict_types=1);
namespace Mop_Ai_Indexer\Admin\Logic;

/**
 * Provides an array of argument arrays of admin menu pages
 *
 * @link       https://ministryofplugins.com/anjana-hemachandra
 * @since      1.0.0
 *
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin/logic
 */

/**
 * If this file is called directly, then exit.
 */
if (! defined('ABSPATH')) exit;

/**
 * Provides an array of argument arrays of admin menu pages.
 *
 * This class is to provide an array of argument arrays of admin menu pages.
 *
 * @since      1.0.0
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin/logic
 * @author     Anjana Hemachandra
 */
class Mop_Ai_Indexer_Admin_Menu_Pages {

	/**
	 * Instance of Mop_Ai_Indexer_Index_Manager_Page class.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      Mop_Ai_Indexer_Index_Manager_Page    $index_manager_page_obj    Contains the class instance.
	 */
	private static ?Mop_Ai_Indexer_Index_Manager_Page $index_manager_page_obj = null;

	/**
	 * Instance of Mop_Ai_Indexer_Index_Settings_Page class.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      Mop_Ai_Indexer_Index_Settings_Page    $index_settings_page_obj    Contains the class instance.
	 */
	private static ?Mop_Ai_Indexer_Index_Settings_Page $index_settings_page_obj = null;

	/**
	 * Instance of Mop_Ai_Indexer_Concept_And_Help_Page class.
	 *
	 * @since    1.0.3
	 * @access   private
	 * @var      Mop_Ai_Indexer_Concept_And_Help_Page    $concept_and_help_page_obj    Contains the class instance.
	 */
	private static ?Mop_Ai_Indexer_Concept_And_Help_Page $concept_and_help_page_obj = null;

	/**
	 * An array of argument arrays of admin menu pages.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      array    $menu_pages    Contains an array of argument arrays of admin menu pages.
	 */
	private static ?array $menu_pages = null;

	/**
	 * Provides an array of argument arrays of admin menu pages.
	 * 
	 * @since    1.0.0
	 * @see      Mop_Ai_Indexer_Index_Manager_Page
	 * @see      Mop_Ai_Indexer_Index_Settings_Page
	 * @see      Mop_Ai_Indexer_Concept_And_Help_Page
	 * @return   array    An array of argument arrays of admin menu pages.
	 */
	public static function get_menu_pages(): array {

		if (! isset(self::$menu_pages)) {

			self::$index_manager_page_obj = new Mop_Ai_Indexer_Index_Manager_Page();
			self::$index_settings_page_obj = new Mop_Ai_Indexer_Index_Settings_Page();
			self::$concept_and_help_page_obj = new Mop_Ai_Indexer_Concept_And_Help_Page();

			/**
			 * 'is_parent'   => Only in first array 'is_parent' should be true. In all other arrays it should be false.
			 * 'page_title'  => All arrays should have not empty string as 'page_title'.
			 * 'menu_title'  => All arrays should have not empty string as 'menu_title'.
			 * 'capability'  => All arrays should have not empty string as 'capability'.
			 * 'menu_slug'   => All arrays should have not empty string as 'menu_slug'.
			 * 'callback'    => Optional for all arrays.
			 * 'icon_url'    => Only first array may have 'icon_url' and it is optional. All other arrays should not have it.
			 * 'position'    => Optional for all arrays.
			 * 
			 * 'parent_slug' => The first array should not have a 'parent_slug'. 
			 * All other arrays should have 'parent_slug's and should match the 'menu_slug' of the first array.
			 * If the first array is not registered as the parent menu page, all other arrays will not be registered as sub-menu pages.
			 */
			self::$menu_pages = array(
					array(
					'is_parent'  => true,
					'page_title' => esc_html__('MOP AI Indexer', 'mop-ai-indexer'),
					'menu_title' => esc_html__('MOP AI Indexer', 'mop-ai-indexer'),
					'capability' => 'manage_options', 
					'menu_slug'  => 'mop-ai-indexer',
					'callback'   => '',
					'icon_url'   => 'dashicons-index-card',
					'position'   => 50
				),
					array(
					'is_parent'   => false,
					'parent_slug' => 'mop-ai-indexer',
					'page_title'  => esc_html__('Index Manager', 'mop-ai-indexer'),
					'menu_title'  => esc_html__('Index Manager', 'mop-ai-indexer'),
					'capability'  => 'manage_options',
					'menu_slug'   => 'mop-ai-indexer',
					'callback'    => array(self::$index_manager_page_obj, 'display_index_manager_page'),
					'position'    => null
				),
					array(
					'is_parent'   => false,
					'parent_slug' => 'mop-ai-indexer',
					'page_title'  => esc_html__('Index Settings', 'mop-ai-indexer'),
					'menu_title'  => esc_html__('Index Settings', 'mop-ai-indexer'),
					'capability'  => 'manage_options',
					'menu_slug'   => 'mop-ai-indexer-index-settings',
					'callback'    => array(self::$index_settings_page_obj, 'display_index_settings_page'),
					'position'    => null
				),
					array(
					'is_parent'   => false,
					'parent_slug' => 'mop-ai-indexer',
					'page_title'  => esc_html__('Concept and Help', 'mop-ai-indexer'),
					'menu_title'  => esc_html__('Concept and Help', 'mop-ai-indexer'),
					'capability'  => 'manage_options',
					'menu_slug'   => 'mop-ai-indexer-concept-and-help',
					'callback'    => array(self::$concept_and_help_page_obj, 'display_concept_and_help_page'),
					'position'    => null
				)
			);
		}

		return self::$menu_pages;
	}
}
