(function( $ ) {
	'use strict';

	var MopAiIndexerFileGen = {

		isRunning: false,

		init: function() {

			$(document).on('click', '#mop-ai-indexer-generate-file', function(e) {
				e.preventDefault();
				MopAiIndexerFileGen.startGeneration();
			});

			$(document).on('click', '#mop-ai-indexer-delete-file', function(e) {
				e.preventDefault();
				MopAiIndexerFileGen.startDeletion();
			});

			/**
			 * Initial paint: show the latest stored logs (and current status if a job is running).
			 */
			MopAiIndexerFileGen.refreshStatus();
		},

		ajaxUrl: function() {
			return (window.mop_ai_indexer_admin_data_obj && mop_ai_indexer_admin_data_obj.ajaxUrl) ? mop_ai_indexer_admin_data_obj.ajaxUrl : ajaxurl;
		},

		nonce: function() {
			return (window.mop_ai_indexer_admin_data_obj && mop_ai_indexer_admin_data_obj.nonce) ? mop_ai_indexer_admin_data_obj.nonce : '';
		},
		getI18n: function(key) {

			if (! (window.mop_ai_indexer_admin_data_obj && mop_ai_indexer_admin_data_obj.i18n && typeof mop_ai_indexer_admin_data_obj.i18n === 'object')) return '';
			if (! (typeof key === 'string' && key)) return '';

			return (typeof mop_ai_indexer_admin_data_obj.i18n[key] === 'string') ? mop_ai_indexer_admin_data_obj.i18n[key] : '';
		},


		refreshStatus: function() {

			$.post(
				MopAiIndexerFileGen.ajaxUrl(),
				{
					action: 'mop_ai_indexer_get_generation_status',
					_ajax_nonce: MopAiIndexerFileGen.nonce()
				}
			).done(function(resp) {

				if (resp && resp.success && resp.data) {
					MopAiIndexerFileGen.applyStatus(resp.data, true);
				}
			});
		},

		startGeneration: function() {

			if (MopAiIndexerFileGen.isRunning) return;

			MopAiIndexerFileGen.isRunning = true;
			MopAiIndexerFileGen.disableButtons(true);
			MopAiIndexerFileGen.showProgressUi(true);
			MopAiIndexerFileGen.updateProgress(0, MopAiIndexerFileGen.getI18n('generating'));

			$.post(
				MopAiIndexerFileGen.ajaxUrl(),
				{
					action: 'mop_ai_indexer_start_generation',
					_ajax_nonce: MopAiIndexerFileGen.nonce()
				}
			).done(function(resp) {

				if (resp && resp.success && resp.data) {
					MopAiIndexerFileGen.applyStatus(resp.data);
					MopAiIndexerFileGen.processNextGeneration();
					return;
				}

				MopAiIndexerFileGen.fail(resp);
			}).fail(function(resp) {
				MopAiIndexerFileGen.fail(resp);
			});
		},

		processNextGeneration: function() {

			$.post(
				MopAiIndexerFileGen.ajaxUrl(),
				{
					action: 'mop_ai_indexer_process_generation',
					_ajax_nonce: MopAiIndexerFileGen.nonce()
				}
			).done(function(resp) {

				if (resp && resp.success && resp.data) {

					MopAiIndexerFileGen.applyStatus(resp.data);

					if (resp.data.status === 'running') {
						window.setTimeout(function(){
							MopAiIndexerFileGen.processNextGeneration();
						}, 150);
						return;
					}

					MopAiIndexerFileGen.done();
					return;
				}

				MopAiIndexerFileGen.fail(resp);
			}).fail(function(resp) {
				MopAiIndexerFileGen.fail(resp);
			});
		},

		startDeletion: function() {

			if (MopAiIndexerFileGen.isRunning) return;

			MopAiIndexerFileGen.isRunning = true;
			MopAiIndexerFileGen.disableButtons(true);
			MopAiIndexerFileGen.showProgressUi(true);
			MopAiIndexerFileGen.updateProgress(0, MopAiIndexerFileGen.getI18n('deleting'));

			$.post(
				MopAiIndexerFileGen.ajaxUrl(),
				{
					action: 'mop_ai_indexer_start_deletion',
					_ajax_nonce: MopAiIndexerFileGen.nonce()
				}
			).done(function(resp) {

				if (resp && resp.success && resp.data) {
					MopAiIndexerFileGen.applyStatus(resp.data);
					MopAiIndexerFileGen.processNextDeletion();
					return;
				}

				MopAiIndexerFileGen.fail(resp);
			}).fail(function(resp) {
				MopAiIndexerFileGen.fail(resp);
			});
		},

		processNextDeletion: function() {

			$.post(
				MopAiIndexerFileGen.ajaxUrl(),
				{
					action: 'mop_ai_indexer_process_deletion',
					_ajax_nonce: MopAiIndexerFileGen.nonce()
				}
			).done(function(resp) {

				if (resp && resp.success && resp.data) {

					MopAiIndexerFileGen.applyStatus(resp.data);

					if (resp.data.status === 'running') {
						window.setTimeout(function(){
							MopAiIndexerFileGen.processNextDeletion();
						}, 150);
						return;
					}

					MopAiIndexerFileGen.done();
					return;
				}

				MopAiIndexerFileGen.fail(resp);
			}).fail(function(resp) {
				MopAiIndexerFileGen.fail(resp);
			});
		},

		applyStatus: function(data, isInit) {

			var status = (data && data.status) ? data.status : '';
			var percent = (data && typeof data.percent !== 'undefined') ? parseInt(data.percent, 10) : 0;
			var message = (data && data.message) ? data.message : '';

			if (data && data.file_status_html) {
				$('#mop-ai-indexer-file-status').html(data.file_status_html);
			}

			/**
			 * Logs box.
			 */
			if (data && (typeof data.logs_title !== 'undefined' || typeof data.logs !== 'undefined')) {
				MopAiIndexerFileGen.renderLogs(data.logs_title ? data.logs_title : '', (data.logs && $.isArray(data.logs)) ? data.logs : []);
			}

			/**
			 * Progress UI.
			 */
			if (status === 'running') {

				MopAiIndexerFileGen.showProgressUi(true);
				MopAiIndexerFileGen.updateProgress(percent, message);
				return;
			}

			if (status === 'idle') {

				/**
				 * Do not flash the progress UI on initial page load.
				 */
				MopAiIndexerFileGen.showProgressUi(false);
				MopAiIndexerFileGen.updateProgress(0, '');
				if (isInit) return;

				return;
			}

			/**
			 * Completed or unknown status.
			 */
			MopAiIndexerFileGen.showProgressUi(true);
			MopAiIndexerFileGen.updateProgress(percent, message);

			window.setTimeout(function(){
				MopAiIndexerFileGen.showProgressUi(false);
				MopAiIndexerFileGen.updateProgress(0, '');
			}, 1500);
		},

		renderLogs: function(title, lines) {

			if (title) {
				$('#mop-ai-indexer-genlog-title').text(title);
			}

			var $container = $('#mop-ai-indexer-genlog-lines');
			if (! $container.length) return;

			$container.empty();

			if (! lines || ! lines.length) {
				$container.append(
					$('<div />')
						.addClass('mop-ai-indexer-genlog-line mop-ai-indexer-genlog-empty')
						.text(MopAiIndexerFileGen.getI18n('no_generation_logs'))
				);
				return;
			}

			$.each(lines, function(i, line) {
				$container.append(
					$('<div />')
						.addClass('mop-ai-indexer-genlog-line')
						.text(line)
				);
			});

			/**
			 * Keep the newest entries visible.
			 */
			try {
				$container.scrollTop($container[0].scrollHeight);
			} catch (e) {
				/* noop */
			}
		},

		updateProgress: function(percent, message) {

			percent = isNaN(percent) ? 0 : percent;
			if (percent < 0) percent = 0;
			if (percent > 100) percent = 100;

			$('#mop-ai-indexer-progress-bar').css('width', percent + '%');
			$('#mop-ai-indexer-progress-percent').text(percent + '%');

			if (typeof message === 'string') {
				$('#mop-ai-indexer-progress-message').text(message);
			}
		},

		showProgressUi: function(show) {

			if (show) {
				$('#mop-ai-indexer-progress-ui').show();
			}else{
				$('#mop-ai-indexer-progress-ui').hide();
			}
		},

		disableButtons: function(disable) {

			if (disable) {
				$('#mop-ai-indexer-generate-file').prop('disabled', true);
				$('#mop-ai-indexer-delete-file').prop('disabled', true);
			}else{
				$('#mop-ai-indexer-generate-file').prop('disabled', false);
				$('#mop-ai-indexer-delete-file').prop('disabled', false);
			}
		},

		done: function() {

			MopAiIndexerFileGen.isRunning = false;
			MopAiIndexerFileGen.disableButtons(false);
		},

		fail: function(resp) {

			MopAiIndexerFileGen.isRunning = false;
			MopAiIndexerFileGen.disableButtons(false);

			var msg = MopAiIndexerFileGen.getI18n('error');
			var logsTitle = '';
			var logsLines = [];

			try {
				if (resp && resp.responseJSON && resp.responseJSON.data) {

					if (resp.responseJSON.data.message) {
						msg = resp.responseJSON.data.message;
					}

					if (typeof resp.responseJSON.data.logs_title !== 'undefined') {
						logsTitle = resp.responseJSON.data.logs_title ? resp.responseJSON.data.logs_title : '';
					}

					if (typeof resp.responseJSON.data.logs !== 'undefined' && $.isArray(resp.responseJSON.data.logs)) {
						logsLines = resp.responseJSON.data.logs;
					}
				}else if (resp && resp.data) {

					if (resp.data.message) {
						msg = resp.data.message;
					}

					if (typeof resp.data.logs_title !== 'undefined') {
						logsTitle = resp.data.logs_title ? resp.data.logs_title : '';
					}

					if (typeof resp.data.logs !== 'undefined' && $.isArray(resp.data.logs)) {
						logsLines = resp.data.logs;
					}
				}
			} catch (e) {
				msg = msg;
			}

			if (logsTitle || (logsLines && logsLines.length)) {
				MopAiIndexerFileGen.renderLogs(logsTitle, logsLines);
			}

			MopAiIndexerFileGen.showProgressUi(true);
			MopAiIndexerFileGen.updateProgress(0, msg);

			window.setTimeout(function(){
				MopAiIndexerFileGen.showProgressUi(false);
				MopAiIndexerFileGen.updateProgress(0, '');
			}, 2000);
		}
	};

	$(function() {
		MopAiIndexerFileGen.init();
	});

})( jQuery );
