<?php
declare(strict_types=1);
namespace Mop_Ai_Indexer\Admin;

/**
 * Adds the top-level administrative menu page and sub-level menu pages
 *
 * @link       https://ministryofplugins.com/anjana-hemachandra
 * @since      1.0.0
 *
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin
 */

/**
 * If this file is called directly, then exit.
 */
if (! defined('ABSPATH')) exit;

/**
 * Import classes from sub-namespaces.
 */
use Mop_Ai_Indexer\Admin\Logic\{Mop_Ai_Indexer_Admin_Menu_Pages};

/**
 * Adds the top-level administrative menu page and sub-level menu pages.
 *
 * This class is to add top-level administrative menu page and sub-level
 * menu pages of the plugin.
 *
 * @since      1.0.0
 * @package    Mop_Ai_Indexer
 * @subpackage Mop_Ai_Indexer/admin
 * @author     Anjana Hemachandra
 */
class Mop_Ai_Indexer_Admin_Menu {

	/**
	 * The array of menu pages.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      array    $menu_pages    Contains an array of menu pages.
	 */
	private static $menu_pages;

	/**
	 * Adds plugin specific menu pages.
	 *
	 * @since    1.0.0
	 * @see      Mop_Ai_Indexer_Admin_Menu_Pages
	 */
	public function add_menu_pages(): void {

		$menu_pages = Mop_Ai_Indexer_Admin_Menu_Pages::get_menu_pages();
		self::$menu_pages = (is_array($menu_pages) && ! empty($menu_pages)) ? $menu_pages : array();

		$loop_count = 0;
		$parent_slug = '';

		foreach (self::$menu_pages as $menu_page) {

			$loop_count++;

			if ($loop_count === 1 &&
				$menu_page['is_parent'] === true &&
				self::is_not_empty_str($menu_page['page_title']) &&
				self::is_not_empty_str($menu_page['menu_title']) &&
				self::is_not_empty_str($menu_page['capability']) &&
				self::is_not_empty_str($menu_page['menu_slug']) &&
				! isset($menu_page['parent_slug'])) {

				add_menu_page(
					$menu_page['page_title'],
					$menu_page['menu_title'],
					$menu_page['capability'], 
					$menu_page['menu_slug'],
					$menu_page['callback'],
					$menu_page['icon_url'],
					$menu_page['position']
				);

				$parent_slug = $menu_page['menu_slug'];

			} elseif ($loop_count > 1 &&
				$menu_page['is_parent'] === false &&
				$menu_page['parent_slug'] === $parent_slug &&
				self::is_not_empty_str($menu_page['parent_slug']) &&
				self::is_not_empty_str($menu_page['page_title']) &&
				self::is_not_empty_str($menu_page['menu_title']) &&
				self::is_not_empty_str($menu_page['capability']) &&
				self::is_not_empty_str($menu_page['menu_slug']) &&
				! isset($menu_page['icon_url'])) {

				add_submenu_page(
					$menu_page['parent_slug'],
					$menu_page['page_title'],
					$menu_page['menu_title'],
					$menu_page['capability'],
					$menu_page['menu_slug'],
					$menu_page['callback'],
					$menu_page['position']
				);
			}
		}
	}

	/**
	 * Checks if a value is a string and not empty.
	 *
	 * @since    1.0.0 
	 * @access   private
	 * @param    string    $str    The string which is to be verified as not an empty string.
	 * @return   bool              True if the passed in variable is a string and not empty. Otherwise false.
	 */
	private static function is_not_empty_str(?string $str): bool {

		return (is_string($str) && trim($str) !== '') ? true : false;
	}
}
