<?php
/**
 * Uninstall script for Monzur Mailer.
 *
 * Deletes all plugin data from the database when the plugin is uninstalled.
 *
 * @package MonzurMailer
 * @since 1.0.0
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

$options = [
    'monzurmailer_from_name',
    'monzurmailer_from_email',
    'monzurmailer_footer_note',
    'monzurmailer_email_templates',
    'monzurmailer_email_logs',
    'monzurmailer_smtp_enable',
    'monzurmailer_smtp_host',
    'monzurmailer_smtp_port',
    'monzurmailer_smtp_username',
    'monzurmailer_smtp_password',
    'monzurmailer_smtp_encryption',
];

if ( is_multisite() ) {
    foreach ( get_sites() as $site ) {
        switch_to_blog( $site->blog_id );
        foreach ( $options as $option ) {
            delete_option( $option );
        }
        restore_current_blog();
    }
} else {
    foreach ( $options as $option ) {
        delete_option( $option );
    }
}