<?php
/**
 * Email template for Monzur Mailer.
 * @package MonzurMailer
 */
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Generates the HTML email body with inline CSS.
 *
 * @param string $subject     The email subject.
 * @param string $message     The email message content.
 * @param string $footer_note The optional footer note.
 * @return string The formatted HTML email body.
 */
function monzurmailer_get_email_template( $subject, $message, $footer_note ) {
    $site_name = get_bloginfo( 'name' );
    ob_start();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo esc_html( $subject ); ?></title>
    </head>
    <body style="margin: 0; padding: 0; font-family: Arial, Helvetica, sans-serif; font-size: 16px; line-height: 1.6; color: #333333; background-color: #f4f4f4;">
        <div style="max-width: 600px; margin: 20px auto; padding: 20px; background-color: #ffffff; border: 1px solid #e0e0e0;">
            <?php echo wp_kses_post( wpautop( $message ) ); ?>
            <p style="font-size: 12px; color: #666666; border-top: 1px solid #eeeeee; padding-top: 10px; margin-top: 20px; text-align: center;">
                <?php
                printf(
                    // translators: %s: The name of the website.
                    esc_html__( 'This email was sent from %s', 'monzurmailer' ),
                    esc_html( $site_name )
                );
                ?>
            </p>
            <?php if ( ! empty( $footer_note ) ) : ?>
                <div style="font-size: 12px; color: #777777; margin-top: 10px;">
                    <?php echo wp_kses_post( wpautop( $footer_note ) ); ?>
                </div>
            <?php endif; ?>
        </div>
    </body>
    </html>
    <?php
    $html = ob_get_clean();
    return apply_filters( 'monzurmailer_email_template_html', $html, $subject, $message, $footer_note );
}