<?php
/**
 * Helper functions for Monzur Mailer.
 * @package MonzurMailer
 */
if ( ! defined( 'ABSPATH' ) ) exit;

function monzurmailer_is_woocommerce_active() {
    return class_exists( 'WooCommerce' );
}

function monzurmailer_get_recipient_options() {
    $options = [ 'manual' => __( 'Manual Email Entry', 'monzurmailer' ), 'all_users' => __( 'All WordPress Users', 'monzurmailer' ), 'by_role' => __( 'Users by Role...', 'monzurmailer' ), ];
    if ( monzurmailer_is_woocommerce_active() ) {
        $wc_options = [ 'wc_customer' => __( 'WooCommerce: All Customers', 'monzurmailer' ), 'wc_shop_manager' => __( 'WooCommerce: All Shop Managers', 'monzurmailer' ), ];
        $options = array_merge( $wc_options, $options );
    }
    return apply_filters( 'monzurmailer_recipient_options', $options );
}

function monzurmailer_get_wordpress_roles() {
    global $wp_roles;
    if ( ! isset( $wp_roles ) ) {
        $wp_roles = new WP_Roles();
    }
    return apply_filters( 'editable_roles', $wp_roles->roles );
}

function monzurmailer_log_email( $to, $subject, $status, $extra = [] ) {
    $logs = get_option( 'monzurmailer_email_logs', [] );
    if ( ! is_array( $logs ) ) $logs = [];
    $sanitized_extra = [];
    if ( ! empty( $extra ) ) $sanitized_extra = array_map( 'wp_kses_post_deep', (array) $extra );
    array_unshift( $logs, [ 'to' => sanitize_text_field( $to ), 'subject' => sanitize_text_field( $subject ), 'date' => current_time( 'mysql' ), 'status' => $status ? 'sent' : 'failed', 'extra' => $sanitized_extra, ] );
    if ( count( $logs ) > 20 ) $logs = array_slice( $logs, 0, 20 );
    update_option( 'monzurmailer_email_logs', $logs );
}

function monzurmailer_get_active_smtp_plugin_name() {
    if ( get_option( 'monzurmailer_smtp_enable', 0 ) ) return 'Monzur Mailer SMTP';
    $smtp_plugins = [ 'wp-mail-smtp/wp_mail_smtp.php' => 'WP Mail SMTP', 'easy-wp-smtp/easy-wp-smtp.php' => 'Easy WP SMTP', 'post-smtp/post-smtp.php' => 'Post SMTP Mailer', 'fluent-smtp/fluent-smtp.php' => 'FluentSMTP', ];
    $active_plugins = (array) get_option( 'active_plugins', [] );
    foreach ( $smtp_plugins as $plugin_file => $plugin_name ) {
        if ( in_array( $plugin_file, $active_plugins, true ) ) return $plugin_name;
    }
    return 'None detected';
}