jQuery(document).ready(function ($) {
    'use strict';
    function switchTab(tabId) {
        $('.monzurmailer-tab-content').hide();
        $('.nav-tab').removeClass('nav-tab-active');
        $('#' + tabId).show();
        $('.nav-tab[data-tab="' + tabId + '"]').addClass('nav-tab-active');
        if (window.history && window.history.pushState) {
            const newUrl = new URL(window.location.href);
            newUrl.searchParams.set('tab', tabId);
            window.history.replaceState({ path: newUrl.href }, '', newUrl.href);
        }
    }
    $('.nav-tab-wrapper').on('click', '.nav-tab', function (e) {
        e.preventDefault();
        switchTab($(this).data('tab'));
    });
    const urlParams = new URLSearchParams(window.location.search);
    const initialTab = urlParams.get('tab') || 'composer';
    switchTab(initialTab);
    function toggleRecipientFields() {
        if (!$('#monzurmailer_recipient_type').length) return;
        const selectedType = $('#monzurmailer_recipient_type').val();
        $('#monzurmailer_manual_recipient_container').toggle(selectedType === 'manual');
        $('#monzurmailer_wp_role_select_container').toggle(selectedType === 'by_role');
    }
    $('#monzurmailer_recipient_type').on('change', toggleRecipientFields).trigger('change');
    function setEditorContent(editorId, content) {
        const textarea = $('#' + editorId);
        if (!textarea.length) return;
        textarea.val(content);
        if (typeof tinymce !== 'undefined') {
            const editor = tinymce.get(editorId);
            if (editor) editor.setContent(content);
        }
    }
    $('#monzurmailer_template_select').on('change', function () {
        const selectedIndex = $(this).val();
        if (selectedIndex === '' || typeof monzurmailer_data.templates[selectedIndex] === 'undefined') {
            $('#monzurmailer_subject').val('');
            setEditorContent('monzurmailer_message', '');
            return;
        }
        const template = monzurmailer_data.templates[selectedIndex];
        $('#monzurmailer_subject').val(template.subject || '');
        setEditorContent('monzurmailer_message', template.message || '');
    });
    function toggleSmtpFields() {
        const smtpEnabled = $('#monzurmailer_smtp_enable').is(':checked');
        $('#monzurmailer_smtp_host, #monzurmailer_smtp_port, #monzurmailer_smtp_username, #monzurmailer_smtp_password, #monzurmailer_smtp_encryption').closest('tr').toggle(smtpEnabled);
    }
    $('#monzurmailer_smtp_enable').on('change', toggleSmtpFields).trigger('change');
    $(document).on('submit', 'form.monzurmailer-form', function (e) {
        e.preventDefault();
        const form = $(this);
        const noticeArea = form.find('.monzurmailer-notice-area');
        const submitButton = form.find('button[type="submit"], input[type="submit"]');
        const originalButtonText = submitButton.is('input') ? submitButton.val() : submitButton.html();
        if (typeof tinymce !== 'undefined') tinymce.triggerSave();
        const formData = form.serialize();
        $.ajax({
            url: monzurmailer_data.ajax_url,
            type: 'POST',
            dataType: 'json',
            data: formData + '&action=monzurmailer_handle_action&nonce=' + monzurmailer_data.nonce,
            beforeSend: function () {
                submitButton.val(monzurmailer_data.text.processing).html(monzurmailer_data.text.processing).prop('disabled', true);
                noticeArea.slideUp().empty();
            },
            success: function (response) {
                const noticeClass = response.success ? 'notice-success' : 'notice-error';
                const message = response.data.message || 'An unknown error occurred.';
                noticeArea.html('<div class="notice ' + noticeClass + ' is-dismissible"><p>' + message + '</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>').slideDown();
                if (response.success && response.data.reload) {
                    const currentUrl = new URL(window.location.href);
                    currentUrl.searchParams.set('ver', new Date().getTime());
                    setTimeout(() => { window.location.href = currentUrl.href; }, 800);
                } else if (response.success) {
                    if (form.attr('id') === 'monzurmailer-add-template-form' || form.attr('id') === 'monzurmailer-compose-form') {
                        form[0].reset();
                        toggleRecipientFields();
                        const editorTextarea = form.find('.wp-editor-area');
                        if (editorTextarea.length) setEditorContent(editorTextarea.attr('id'), '');
                    }
                    if (form.attr('id') === 'monzurmailer-smtp-settings-form') toggleSmtpFields();
                }
            },
            error: function () {
                noticeArea.html('<div class="notice notice-error is-dismissible"><p>An unexpected server error occurred. Please try again.</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>').slideDown();
            },
            complete: function (jqXHR) {
                const responseData = jqXHR.responseJSON?.data || {};
                if (!responseData.reload) submitButton.prop('disabled', false).val(originalButtonText).html(originalButtonText);
            }
        });
    });
    const modal = $('#monzurmailer-edit-modal-backdrop');
    $('.wp-list-table').on('click', 'a.monzurmailer-edit-template', function(e) {
        e.preventDefault();
        const index = $(this).data('index');
        const template = monzurmailer_data.templates[index];
        if (!template) return;
        modal.find('#monzurmailer-edit-template-index').val(index);
        modal.find('#template_title_edit').val(template.title);
        modal.find('#template_subject_edit').val(template.subject);
        setEditorContent('template_message_edit', template.message || '');
        modal.find('.monzurmailer-notice-area').empty();
        modal.fadeIn('fast');
    });
    modal.on('click', '.monzurmailer-edit-modal-close, #monzurmailer-edit-modal-backdrop', function(e) {
        if (e.target !== this) return;
        modal.fadeOut('fast');
    });
    $('.wp-list-table').on('click', 'a.monzurmailer-delete-template', function(e) {
        e.preventDefault();
        if (!confirm(monzurmailer_data.text.confirm_delete)) return;
        const link = $(this);
        const originalText = link.text();
        $.ajax({
            url: monzurmailer_data.ajax_url, type: 'POST', dataType: 'json',
            data: { action: 'monzurmailer_handle_action', form_action: 'delete_template', template_index: $(this).data('index'), nonce: monzurmailer_data.nonce },
            beforeSend: () => link.text(monzurmailer_data.text.processing).css('pointer-events', 'none'),
            success: (response) => {
                if (response.success) {
                    const newUrl = new URL(window.location.href);
                    newUrl.searchParams.set('ver', new Date().getTime());
                    window.location.href = newUrl.href;
                } else {
                    alert('Error: ' + response.data.message);
                    link.text(originalText).css('pointer-events', '');
                }
            },
            error: () => {
                alert('An unexpected server error occurred.');
                link.text(originalText).css('pointer-events', '');
            }
        });
    });
    $('#monzurmailer-clear-logs-btn').on('click', function(e) {
        e.preventDefault();
        if (!confirm('Are you sure you want to clear all email logs? This action cannot be undone.')) return;
        const button = $(this);
        const originalHtml = button.html();
        $.ajax({
            url: monzurmailer_data.ajax_url, type: 'POST', dataType: 'json',
            data: { action: 'monzurmailer_handle_action', form_action: 'clear_logs', nonce: monzurmailer_data.nonce },
            beforeSend: () => button.html(monzurmailer_data.text.processing).prop('disabled', true),
            success: (response) => {
                if (response.success) window.location.reload();
                else {
                    alert('Error: ' + (response.data.message || 'An unknown error occurred.'));
                    button.html(originalHtml).prop('disabled', false);
                }
            },
            error: () => {
                alert('An unexpected server error occurred.');
                button.html(originalHtml).prop('disabled', false);
            }
        });
    });
    $(document).on('click', '.monzurmailer-notice-area .notice-dismiss', function() {
        $(this).closest('.notice').slideUp('fast', function() { $(this).remove(); });
    });
});