<?php
/**
 * Renders the Templates tab content.
 * @package MonzurMailer
 */
if ( ! defined( 'ABSPATH' ) ) exit;
$all_templates = get_option( 'monzurmailer_email_templates', [] );
?>
<div class="wrap monzurmailer-wrap">
    <h2><?php esc_html_e( 'Add New Template', 'monzurmailer' ); ?></h2>
    <form method="post" id="monzurmailer-add-template-form" class="monzurmailer-form">
        <input type="hidden" name="form_action" value="save_template">
        <div class="monzurmailer-notice-area"></div>
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row"><label for="template_title_add"><?php esc_html_e( 'Template Title', 'monzurmailer' ); ?></label></th>
                    <td><input type="text" id="template_title_add" name="template_title" class="regular-text" placeholder="<?php esc_attr_e( 'e.g., Monthly Newsletter', 'monzurmailer' ); ?>" required></td>
                </tr>
                <tr>
                    <th scope="row"><label for="template_subject_add"><?php esc_html_e( 'Email Subject', 'monzurmailer' ); ?></label></th>
                    <td><input type="text" id="template_subject_add" name="template_subject" class="regular-text" required></td>
                </tr>
            </tbody>
        </table>
        <div class="monzurmailer-editor-container">
            <h3><?php esc_html_e( 'Message', 'monzurmailer' ); ?></h3>
            <?php wp_editor( '', 'template_message_add', [ 'textarea_name' => 'template_message_add', 'textarea_rows' => 10 ] ); ?>
        </div>
        <?php submit_button( __( 'Add Template', 'monzurmailer' ) ); ?>
    </form>
    <hr>
    <h2><?php esc_html_e( 'Saved Templates', 'monzurmailer' ); ?></h2>
    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th scope="col" style="width:35%"><?php esc_html_e( 'Title', 'monzurmailer' ); ?></th>
                <th scope="col" style="width:40%"><?php esc_html_e( 'Subject', 'monzurmailer' ); ?></th>
                <th scope="col" style="width:25%"><?php esc_html_e( 'Actions', 'monzurmailer' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ( ! empty( $all_templates ) ) : ?>
                <?php foreach ( $all_templates as $index => $template ) : ?>
                    <tr>
                        <td><?php echo esc_html( $template['title'] ); ?></td>
                        <td><?php echo esc_html( $template['subject'] ); ?></td>
                        <td>
                            <a href="#" class="button button-secondary monzurmailer-edit-template" data-index="<?php echo esc_attr( $index ); ?>"><?php esc_html_e( 'Edit', 'monzurmailer' ); ?></a>
                            <a href="#" class="button button-danger monzurmailer-delete-template" data-index="<?php echo esc_attr( $index ); ?>"><?php esc_html_e( 'Delete', 'monzurmailer' ); ?></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr><td colspan="3"><?php esc_html_e( 'No templates saved yet. Add one above!', 'monzurmailer' ); ?></td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<!-- Hidden Edit Form Modal -->
<div id="monzurmailer-edit-modal-backdrop" style="display:none;">
    <div id="monzurmailer-edit-modal-content">
        <form id="monzurmailer-edit-template-form" class="monzurmailer-form">
            <h2 id="monzurmailer-edit-modal-title"><?php esc_html_e( 'Edit Template', 'monzurmailer' ); ?></h2>
            <button type="button" class="monzurmailer-edit-modal-close" aria-label="<?php esc_attr_e( 'Close', 'monzurmailer' ); ?>">×</button>
            <input type="hidden" name="form_action" value="save_template">
            <input type="hidden" name="template_index" id="monzurmailer-edit-template-index" value="">
            <div class="monzurmailer-notice-area"></div>
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="template_title_edit"><?php esc_html_e( 'Template Title', 'monzurmailer' ); ?></label></th>
                        <td><input type="text" id="template_title_edit" name="template_title" class="regular-text" required></td>
                    </tr>
                     <tr>
                        <th scope="row"><label for="template_subject_edit"><?php esc_html_e( 'Email Subject', 'monzurmailer' ); ?></label></th>
                        <td><input type="text" id="template_subject_edit" name="template_subject" class="regular-text" required></td>
                    </tr>
                </tbody>
            </table>
            <div class="monzurmailer-editor-container">
                <h3><?php esc_html_e( 'Message', 'monzurmailer' ); ?></h3>
                <?php wp_editor( '', 'template_message_edit', [ 'textarea_name' => 'template_message_edit', 'textarea_rows' => 10 ] ); ?>
            </div>
            <?php submit_button( __( 'Update Template', 'monzurmailer' ), 'primary large' ); ?>
        </form>
    </div>
</div>