<?php
/**
 * Renders the Settings tab content.
 * @package MonzurMailer
 */
if ( ! defined( 'ABSPATH' ) ) exit;

$from_name   = get_option( 'monzurmailer_from_name', get_bloginfo( 'name' ) );
$from_email  = get_option( 'monzurmailer_from_email', get_option( 'admin_email' ) );
$footer_note = get_option( 'monzurmailer_footer_note', '' );
?>
<div class="wrap monzurmailer-wrap">
    <h2><?php esc_html_e( 'General Settings', 'monzurmailer' ); ?></h2>
    <form method="post" id="monzurmailer-settings-form" class="monzurmailer-form">
        <input type="hidden" name="form_action" value="save_settings">
        <div class="monzurmailer-notice-area"></div>
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row"><label for="monzurmailer_from_name"><?php esc_html_e( 'From Name', 'monzurmailer' ); ?></label></th>
                    <td><input type="text" id="monzurmailer_from_name" name="monzurmailer_from_name" value="<?php echo esc_attr( $from_name ); ?>" class="regular-text" /></td>
                </tr>
                <tr>
                    <th scope="row"><label for="monzurmailer_from_email"><?php esc_html_e( 'From Email', 'monzurmailer' ); ?></label></th>
                    <td>
                        <input type="email" id="monzurmailer_from_email" name="monzurmailer_from_email" value="<?php echo esc_attr( $from_email ); ?>" class="regular-text" />
                        <p class="description"><?php esc_html_e( 'Defaults to the site admin email. Avoid using "noreply" addresses to improve email deliverability.', 'monzurmailer' ); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="monzurmailer_footer_note"><?php esc_html_e( 'Email Footer Note', 'monzurmailer' ); ?></label></th>
                    <td>
                        <textarea id="monzurmailer_footer_note" name="monzurmailer_footer_note" rows="4" class="regular-text"><?php echo esc_textarea( $footer_note ); ?></textarea>
                        <p class="description"><?php esc_html_e( 'Optional. This note will be appended to all emails.', 'monzurmailer' ); ?></p>
                    </td>
                </tr>
            </tbody>
        </table>
        <?php submit_button( __( 'Save Settings', 'monzurmailer' ) ); ?>
    </form>
    <hr>
    <h2><?php esc_html_e( 'SMTP Settings (Optional)', 'monzurmailer' ); ?></h2>
    <p>
    <?php
    printf(
        // Translators: %s is the URL to the plugin documentation.
        esc_html__( 'To ensure emails land in the inbox, enable SMTP and configure your domain DNS records (SPF, DKIM, DMARC). %s', 'monzurmailer' ),
        sprintf(
            '<a href="%s" target="_blank" rel="noopener noreferrer">%s</a>',
            esc_url( 'https://monzurrahman.github.io/MonzurMailer/' ),
            esc_html__( 'See the documentation for setup guides', 'monzurmailer' )
        )
    );
    ?>
   </p> 
    <form method="post" id="monzurmailer-smtp-settings-form" class="monzurmailer-form">
        <input type="hidden" name="form_action" value="save_smtp_settings">
        <div class="monzurmailer-notice-area"></div>
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row"><label for="monzurmailer_smtp_enable"><?php esc_html_e( 'Enable SMTP', 'monzurmailer' ); ?></label></th>
                    <td>
                        <input type="checkbox" id="monzurmailer_smtp_enable" name="monzurmailer_smtp_enable" value="1" <?php checked( get_option( 'monzurmailer_smtp_enable', 0 ) ); ?> />
                        <p class="description"><?php esc_html_e( 'Use SMTP for reliable email delivery.', 'monzurmailer' ); ?></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="monzurmailer_smtp_host"><?php esc_html_e( 'SMTP Host', 'monzurmailer' ); ?></label></th>
                    <td><input type="text" id="monzurmailer_smtp_host" name="monzurmailer_smtp_host" value="<?php echo esc_attr( get_option( 'monzurmailer_smtp_host', '' ) ); ?>" class="regular-text" /></td>
                </tr>
                <tr>
                    <th scope="row"><label for="monzurmailer_smtp_port"><?php esc_html_e( 'SMTP Port', 'monzurmailer' ); ?></label></th>
                    <td><input type="number" id="monzurmailer_smtp_port" name="monzurmailer_smtp_port" value="<?php echo esc_attr( get_option( 'monzurmailer_smtp_port', '' ) ); ?>" class="regular-text" /></td>
                </tr>
                <tr>
                    <th scope="row"><label for="monzurmailer_smtp_username"><?php esc_html_e( 'SMTP Username', 'monzurmailer' ); ?></label></th>
                    <td><input type="text" id="monzurmailer_smtp_username" name="monzurmailer_smtp_username" value="<?php echo esc_attr( get_option( 'monzurmailer_smtp_username', '' ) ); ?>" class="regular-text" autocomplete="off" /></td>
                </tr>
                <tr>
                    <th scope="row"><label for="monzurmailer_smtp_password"><?php esc_html_e( 'SMTP Password', 'monzurmailer' ); ?></label></th>
                    <td><input type="password" id="monzurmailer_smtp_password" name="monzurmailer_smtp_password" value="<?php echo esc_attr( get_option( 'monzurmailer_smtp_password', '' ) ); ?>" class="regular-text" autocomplete="off" /></td>
                </tr>
                <tr>
                    <th scope="row"><label for="monzurmailer_smtp_encryption"><?php esc_html_e( 'Encryption', 'monzurmailer' ); ?></label></th>
                    <td>
                        <select id="monzurmailer_smtp_encryption" name="monzurmailer_smtp_encryption">
                            <option value="none" <?php selected( get_option( 'monzurmailer_smtp_encryption', 'none' ), 'none' ); ?>><?php esc_html_e( 'None', 'monzurmailer' ); ?></option>
                            <option value="ssl" <?php selected( get_option( 'monzurmailer_smtp_encryption', 'none' ), 'ssl' ); ?>><?php esc_html_e( 'SSL', 'monzurmailer' ); ?></option>
                            <option value="tls" <?php selected( get_option( 'monzurmailer_smtp_encryption', 'none' ), 'tls' ); ?>><?php esc_html_e( 'TLS', 'monzurmailer' ); ?></option>
                        </select>
                    </td>
                </tr>
            </tbody>
        </table>
        <?php submit_button( __( 'Save SMTP Settings', 'monzurmailer' ) ); ?>
    </form>
    <hr>
    <h2><?php esc_html_e( 'Send Test Email', 'monzurmailer' ); ?></h2>
    <form method="post" class="monzurmailer-form">
        <input type="hidden" name="form_action" value="send_test_email">
        <div class="monzurmailer-notice-area"></div>
        <p>
            <input type="email" name="monzurmailer_test_email_to" placeholder="<?php esc_attr_e( 'Enter your email address', 'monzurmailer' ); ?>" class="regular-text" required>
            <button type="submit" class="button button-secondary"><?php esc_html_e( 'Send Test', 'monzurmailer' ); ?></button>
        </p>
    </form>
    <hr>
    <h2><?php esc_html_e( 'Email Diagnostics', 'monzurmailer' ); ?></h2>
    <table class="widefat striped" style="max-width: 700px;">
        <tbody>
            <tr>
                <th><?php esc_html_e( 'PHP mail() function', 'monzurmailer' ); ?></th>
                <td><?php echo function_exists( 'mail' ) ? '<span class="dashicons dashicons-yes-alt"></span> Available' : '<span class="dashicons dashicons-dismiss"></span> Not Available'; ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e( 'WordPress wp_mail()', 'monzurmailer' ); ?></th>
                <td><?php echo function_exists( 'wp_mail' ) ? '<span class="dashicons dashicons-yes-alt"></span> Available' : '<span class="dashicons dashicons-dismiss"></span> Not Available'; ?></td>
            </tr>
            <tr>
                <th><?php esc_html_e( 'Active SMTP Method', 'monzurmailer' ); ?></th>
                <td>
                    <?php
                        $smtp_plugin = monzurmailer_get_active_smtp_plugin_name();
                        if ( 'None detected' !== $smtp_plugin ) {
                            echo '<span class="dashicons dashicons-yes-alt"></span> ' . esc_html( $smtp_plugin );
                        } else {
                            echo '<span class="dashicons dashicons-dismiss"></span> None detected';
                        }
                    ?>
                </td>
            </tr>
        </tbody>
    </table>
</div>