<?php
/**
 * Renders the Email Logs tab content.
 * @package MonzurMailer
 */
if ( ! defined( 'ABSPATH' ) ) exit;

$email_logs = get_option( 'monzurmailer_email_logs', [] );
?>
<div class="wrap monzurmailer-wrap">
    <div class="monzurmailer-logs-header">
        <h2><?php esc_html_e( 'Email Logs', 'monzurmailer' ); ?></h2>
        <?php if ( ! empty( $email_logs ) ) : ?>
            <a href="#" id="monzurmailer-clear-logs-btn" class="button button-secondary">
                <span class="dashicons dashicons-trash" aria-hidden="true"></span>
                <?php esc_html_e( 'Clear All Logs', 'monzurmailer' ); ?>
            </a>
        <?php endif; ?>
    </div>
    <p><?php esc_html_e( 'Showing the last 20 emails sent from the Composer.', 'monzurmailer' ); ?></p>
    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th scope="col" style="width: 15%;"><?php esc_html_e( 'Date', 'monzurmailer' ); ?></th>
                <th scope="col" style="width: 20%;"><?php esc_html_e( 'Recipients', 'monzurmailer' ); ?></th>
                <th scope="col" style="width: 20%;"><?php esc_html_e( 'Subject', 'monzurmailer' ); ?></th>
                <th scope="col" style="width: 15%;"><?php esc_html_e( 'From Email', 'monzurmailer' ); ?></th>
                <th scope="col" style="width: 20%;"><?php esc_html_e( 'Failed Emails', 'monzurmailer' ); ?></th>
                <th scope="col" style="width: 5%;"><?php esc_html_e( 'Status', 'monzurmailer' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ( ! empty( $email_logs ) ) : ?>
                <?php foreach ( $email_logs as $log ) : ?>
                    <tr>
                        <td><?php echo esc_html( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( $log['date'] ) ) ); ?></td>
                        <td><?php echo isset( $log['extra']['to_emails'] ) && ! empty( $log['extra']['to_emails'] ) ? esc_html( implode( ', ', $log['extra']['to_emails'] ) ) : esc_html( $log['to'] ); ?></td>
                        <td><?php echo esc_html( $log['subject'] ); ?></td>
                        <td><?php echo isset( $log['extra']['from_email'] ) ? esc_html( $log['extra']['from_email'] ) : '-'; ?></td>
                        <td><?php echo isset( $log['extra']['failed_emails'] ) && ! empty( $log['extra']['failed_emails'] ) ? esc_html( implode( ', ', $log['extra']['failed_emails'] ) ) : '-'; ?></td>
                        <td>
                            <?php if ( isset( $log['status'] ) && 'sent' === $log['status'] ) : ?>
                                <span class="dashicons dashicons-yes-alt" title="<?php esc_attr_e( 'Sent', 'monzurmailer' ); ?>"></span>
                            <?php else : ?>
                                <span class="dashicons dashicons-dismiss" title="<?php esc_attr_e( 'Failed', 'monzurmailer' ); ?>"></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr><td colspan="6"><?php esc_html_e( 'No email logs found.', 'monzurmailer' ); ?></td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>